'use strict';

module.exports = app => {
  const { DataTypes } = app.Sequelize;

  const Register = app.model.define('register', {
    id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
      field: 'id',
    },
    orderId: {
      type: DataTypes.STRING(255),
      allowNull: false,
      defaultValue: '',
      primaryKey: true,
      field: 'orderId',
    },
    taskId: {
      type: DataTypes.STRING(255),
      allowNull: false,
      defaultValue: '',
      field: 'taskId',
    },
    appkey: {
      type: DataTypes.STRING(255),
      allowNull: true,
      field: 'appKey',
    },
    status: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: '',
      field: 'status',
    },
    note: {
      type: DataTypes.STRING(8000),
      allowNull: true,
      defaultValue: '',
      field: 'note',
      get() {
        const note = this.getDataValue('note');
        if (note) {
          try {
            return JSON.parse(note);
          } catch (error) {
            return {};
          }
        }
        return {};
      },
      set(val) {
        this.setDataValue('note', JSON.stringify(val));
      },
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'createDate',
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'updateDate',
    },
    text1: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: '',
      field: 'text1',
    },
    text2: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: '',
      field: 'text2',
    },
    text3: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: '',
      field: 'text3',
    },
  }, {
    tableName: 'xuexin_register_status',
    // timestamps: false,
  });

  return Register;
};
