'use strict';

const Service = require('egg').Service;


class CacheService extends Service {
  constructor(ctx) {
    super(ctx);
    const { config } = this;
    const { registerTaskPrefix } = config.lockKeys;
    this.registerTaskPrefix = registerTaskPrefix;
  }

  /**
   * 将taskId状态缓存到redis和数据库
   * @param {Object} key taskId
   *   - value: 状态 提示信息 status 、note={}
   *   - exprie: 过期时间
   */
  async set({ key, value = {}, exprie = 300 }) {
    const { ctx, app, registerTaskPrefix } = this;

    const data = await app.redis.get(registerTaskPrefix + key);
    if (!data || (data && data.status !== 'success')) {
      await app.redis.set(registerTaskPrefix + key, JSON.stringify(value), 'EX', exprie);
    }

    const order = await ctx.model.Register.findOne({
      where: { taskId: key },
    });
    if (order && order.status !== 'success') {
      await order.update({ ...value });
    } else {
      ctx.logger.error('【registerCache】set no order or already success', key);
    }
    ctx.logger.info(`【registerCache】set ${key} value:`, JSON.stringify(value));
  }

  /**
   * 获取task状态 优先redis
   * @param {Object} key taskId
   * @return {Object} status note
   */

  async get({ key }) {
    const { ctx, app, registerTaskPrefix } = this;
    const data = await app.redis.get(registerTaskPrefix + key);
    if (data) {
      ctx.logger.info(`【registerCache】get From redis ${key} data:`, data);
      return JSON.parse(data);
    }
    const order = await ctx.model.Register.findOne({
      where: { taskId: key },
    });
    if (order) {
      ctx.logger.info(`【registerCache】get From Model ${key} order:`, JSON.stringify({ status: order.status, note: order.note }));
      return { status: order.status, note: order.note };
    }
    ctx.logger.error(`【registerCache】get No Result ${key} `);
    this.ctx.throw(400, { message: 'no taskId' });
  }
}

module.exports = CacheService;