'use strict';

module.exports = () => {
  const config = exports = {};
  config.debug = true;
  config.logger = {
    dir: '/jianbing/logs/xuexin_h5',
  };

  config.projectRootPath = '/xuexin_h5';

  config.redis = {
    client: {
      port: 6379,
      host: process.env.REDIS_HOST,
      password: process.env.REDIS_PWD,
      db: 0,
    },
  };
  
  config.taskAPI = {
    host: process.env.TASKAPI_HOST,
    loginParamUrl: '/CreditCardServices/GetCcSetting',
    createTaskUrl: '/CreditCardServices/CreateCreditCardTask',
    fetchCodeUrl: '/CreditCardServices/QueryCreditCardCode',
    submitTaskUrl: '/CreditCardServices/QueryCreditCard',
    fetchTaskUrl: '/CreditCardServices/GetCcData'
};

config.registerAPI = {
  host: 'http://ts1.51gjj.com:18525',
  loginParamUrl: '/xxregister/getSettings',
  createTaskUrl: '/xxregister/createTask',
  fetchCodeUrl: '/xxregister/getCode',
  submitTaskUrl: '/xxregister/loginWeb',
  fetchTaskUrl: '/xxregister/getData'
};

config.findpwdAPI = {
  host: 'http://ts1.51gjj.com:18526',
  loginParamUrl: '/xxfindpwd/getSettings',
  createTaskUrl: '/xxfindpwd/createTask',
  fetchCodeUrl: '/xxfindpwd/getCode',
  submitTaskUrl: '/xxfindpwd/loginWeb',
  fetchTaskUrl: '/xxfindpwd/getData'
};

  config.partnerAPI = {
    host: process.env.PARTNERAPI_HOST,
    fetchTheme: '/chaos/theme',
    fetchScripts: '/chaos/partners/scripts',
    fetchAgreements: '/chaos/agreements',
    fetchInfo: '/chaos/partner',
    redisThemePrefix: 'URANUS.XX.PARNTERS.THEME',
    redisScriptsPrefix: 'URANUS.XX.PARNTERS.SCRIPTS',
    redisAgreementsPrefix: 'URANUS.XX.PARNTERS.Agreements',
    redisInfoPrefix: 'URANUS.XX.PARNTERS.Info',
    redisappKeyLimitPrefix: 'URANUS.XX.PARNTERS.Limit',
  };

  config.scriptsAPI = {
    host: process.env.SCRIPTSAPI_HOST,
    fetchScriptsUrl: '/chaos/xx/two_dimension_array/queries',
    fetchOneScriptUrl: '/chaos/xx/two_dimension_array/info',
    fetchParamsInfoUrl: '/chaos/xx/login_param_map',
    fetchQueryButtonUrl: '/chaos/xx/query_button',
    fetchHelpUrl: '/chaos/xx/help',
    fetchNoticeUrl: '/chaos/xx/notice',
    fetchHubSeriptsUrl: '/chaos/xx/hubs',
    fetchScriptByCityNameUrl: '/chaos/xx/city_scripts',
    redisScriptsKey: 'URANUS.XX.SCRIPTS',
    redisParamsKey: 'URANUS.XX.PARAMS',
    redisScriptListKey: 'URANUS.XX.SCRIPTLIST',
  };

  config.storageAPI = {
    host: process.env.STORAGEAPI_HOST,
    writeUrl: '/data',
    readUrl: '/Chsi',
    writeType: 'chsi',
    readDataKey: 'ChsiReport',
  };

  config.washAPI = {
    host: '',
    washUrl: '',
  };

  config.signatureAPI = {
    host: process.env.SIGNATUREAPI_HOST,
    fetchTokenUrl: '/Access/GetToken',
    fetchOrderIdUrl: '/Order/GetOrderSn',
    signatureUrl: '/Access/SignValidityCheck',
    fetchParnterUrl: '',
    signatureType: 'xx',
    customerUrl: '/customer/query',
  };

  config.lockKeys = {
    fecthHub: 'URANUS.XX.HUBS.LOCK',
    fecteToken: 'URANUS.XX.TOKEN.LOCK',
    token: 'URANUS.XX.TOKEN',
    fecthParnters: 'URANUS.XX.PARNTERS.LOCK',
    taskPrefix: 'URANUS.XX.TASK',
  };

  config.sequelize = {
    datasources: [{
      // 东八时区
      timezone: '+08:00',
      delegate: 'model',
      baseDir: 'model',
      dialect: 'mysql',
      host: process.env.MYSQL_PACHONG_HOST,
      database: process.env.MYSQL_DATA_SERVER_DB_NAME,
      username: process.env.MYSQL_USER,
      password: process.env.MYSQL_PWD,
      port: process.env.MYSQL_PORT,
    }],
  };

  config.callbackUrl = process.env.CALLBACK_URL;

  return config;
};
