'use strict';

/**
 * @param {Egg.Application} app - egg application
 */
module.exports = app => {
  const { router, controller } = app;

  const chsiRouter = router.namespace(app.config.projectRootPath);
  chsiRouter.get('/loginScripts', controller.task.getSetting); // 获取学信登录参数
  chsiRouter.post('/tasks', controller.task.create); // 创建任务
  chsiRouter.get('/tasks/:taskId', controller.task.show); // 获取任务状态
  chsiRouter.post('/tasks/:taskId/submit', controller.task.submit); // 提交任务参数
  // chsiRouter.post('/tasks/:taskId/capture', controller.task.fetchCapture); // 获取验证码
  
  chsiRouter.post('/callback', controller.task.handleCallback); // 处理回调结果，不对外

  chsiRouter.get('/registerScripts', controller.register.getSetting); // 获取注册登录参数
  chsiRouter.post('/registerTasks', controller.register.create); // 注册-创建任务
  chsiRouter.get('/registerTasks/:taskId', controller.register.show); // 注册-获取任务状态
  chsiRouter.post('/registerTasks/:taskId/submit', controller.register.submit); // 注册-提交任务参数
// chsiRouter.post('/registerTasks/:taskId/capture', controller.register.fetchCapture); // 注册-获取验证码

  chsiRouter.get('/findPwdScripts', controller.findpwd.getSetting); // 找回密码-获取登录参数
  chsiRouter.post('/findPwdTasks', controller.findpwd.create); // 找回密码-创建任务
  chsiRouter.get('/findPwdTasks/:taskId', controller.findpwd.show); // 找回密码-获取任务状态
  chsiRouter.post('/findPwdTasks/:taskId/submit', controller.findpwd.submit); // 找回密码-提交任务参数
// chsiRouter.post('/findPwdTasks/:taskId/capture', controller.findpwd.fetchCapture); // 找回密码-获取验证码

  chsiRouter.get('/theme/:appKey', controller.partner.show);// 配置主题
  chsiRouter.get('/agreements/:id', controller.partner.fetchAgreements);//查询协议

  chsiRouter.post('/tokens', controller.token.create); // 创建token
  chsiRouter.post('/orders', controller.order.create); // 创建订单号

  chsiRouter.post('/getToken', controller.token.partnerToken);     // 合作方获取token
  chsiRouter.post('/getorderSn', controller.order.partnerOrder);   // 合作方获取orderSn

  chsiRouter.post('/getData', controller.order.partnerData);       // 合作方拉数据

  chsiRouter.get('/orderData/:appKey/:orderId', controller.order.orderShow);//获取展示页面数据
};