'use strict';

const Service = require('egg').Service;

class TaskService extends Service {
    constructor(ctx) {
        super(ctx);
        const {config} = this;
        const {taskAPI, LOCK_KEY} = config;
        this.baseURL = taskAPI.host;
        this.loginParamUrl = taskAPI.loginParamUrl;
        this.createTaskUrl = taskAPI.createTaskUrl;
        this.submitTaskUrl = taskAPI.submitTaskUrl;
        this.fetchCodeUrl = taskAPI.fetchCodeUrl;
        this.fetchTaskUrl = taskAPI.fetchTaskUrl;
        this.cityConfigUrl = taskAPI.cityConfigUrl;
        this.LOCK_KEY = LOCK_KEY;
    }


    _request(url, opts) {
        const {ctx, baseURL} = this;
        opts = {
            charset: 'utf-8',
            timeout: ['30s', '30s'],
            dataType: 'json',
            contentType: 'json',
            ...opts,
        };
        ctx.logger.info('_request', `${baseURL}${url}`);
        return ctx.curl(`${baseURL}${url}`, opts);
    }

    _checkSuccess(result) {
        if (result.status !== 200) {
            const errorMsg = result.data && result.data.error_msg ? result.data.error_msg : 'unknown error';
            this.ctx.throw(result.status, errorMsg);
        }
        if (result.data.code !== 0) {
            this.ctx.throw(400, {message: result.data.msg, code: result.data.code});
        }
    }

    async fetchLoginParam() {
        const {loginParamUrl, ctx} = this;
        const result = await this._request(loginParamUrl);
        ctx.logger.info(`【Task】create ${loginParamUrl} result:`, JSON.stringify(result.data.code));
        this._checkSuccess(result);
        let loginParam;
        for(let item of result.data.bankList){
            if(item.id === 10003){
                loginParam = item.queryParam[0].loginParam;
            }
        }
        return loginParam;
    }

    async create() {
        const {createTaskUrl, ctx} = this;
        const result = await this._request(createTaskUrl, {
            method: 'post',
            data: {"bankId":"10003"},
        });
        ctx.logger.info(`【Task】create ${createTaskUrl} result:`, JSON.stringify(result.data));
        this._checkSuccess(result);
        return result.data.data.taskId;
    }

    async fetchCapture({taskId, type}) {
        const {fetchCodeUrl, ctx} = this;
        const result = await this._request(fetchCodeUrl, {
            method: 'post',
            data: {
                taskId,
                type,
            },
        });
        ctx.logger.info(`【Task】fetchCapture ${fetchCodeUrl} params`, JSON.stringify({
            taskId,
            type,
        }), result.data.code);
        this._checkSuccess(result);
        return result.data.data;
    }

    async submit(data) {
        const {submitTaskUrl, ctx} = this;
        const result = await this._request(submitTaskUrl, {
            method: 'post',
            data,
        });
        ctx.logger.info(`【Task】submit ${submitTaskUrl} params`, JSON.stringify(data), JSON.stringify(result.data));
        this._checkSuccess(result);
        return result;
    }

    async fetchTask(data) {
        const {fetchTaskUrl, ctx} = this;
        const result = await this._request(fetchTaskUrl, {
            method: 'post',
            data,
        });
        ctx.logger.info(`【Task】fetchTask ${fetchTaskUrl} params`, JSON.stringify(data), JSON.stringify(result.data.code));
        return result.data;
    }
}

module.exports = TaskService;
