'use strict';


module.exports = {
  failed(message) {
    const method = this.request.method.toLowerCase();
    if (method === 'post') {
      this.throw(422, message);
    } else {
      this.throw(400, message);
    }
  },
  success(data = false) {
    const method = this.request.method.toLowerCase();
    if (method === 'get') {
      this.status = 200;
      this.body = data || {};
    } else if (method === 'post') {
      this.status = 201;
      this.body = data || {};
    } else if (method === 'put' || method === 'delete') {
      this.status = data ? 200 : 204;
      this.body = data ? data : '';
    } else {
      this.status = 204;
      this.body = '';
    }
  },
};
