'use strict';


module.exports = () => {
  return async (ctx, next) => {
    if (!ctx.pagination) {

      const query = ctx.query;
      const config = ctx.app.config;
      const pagination = {};

      Object.defineProperties(pagination, {
        defaultSize: {
          enumerable: false,
          configurable: false,
          writable: true,
          value: undefined,
        },
        size: {
          enumerable: true,
          get() {
            let size = Math.min(1000, parseInt(query.size || this.defaultSize || config.default_pagination_size || 10, 10));
            if (isNaN(size)) {
              size = this.defaultSize || config.default_pagination_size || 10;
            }
            return size;
          },
        },
        page: {
          enumerable: true,
          get() {
            let page = Math.max(1, parseInt(query.page || 1, 10));
            if (isNaN(page)) {
              page = 1;
            }
            return page;
          },
        },
      });

      if (query.sorter) {
        const sorter = query.sorter;
        if (/^(.+)_descend$/.test(sorter)) {
          const key = RegExp.$1;
          pagination.order = [[key, 'DESC']];
          pagination.sort_key = key;
        } else if (/^(.+)_ascend$/.test(sorter)) {
          const key = RegExp.$1;
          pagination.order = [[key, 'ASC']];
          pagination.sort_key = key;
        }
      }

      ctx.pagination = pagination;
    }
    await next();
  };
};
