'use strict';

const Service = require('egg').Service;

class UserDetailService extends Service {

  async findAll(type, where, attributes, { size, page }) {
    const { ctx } = this;
    return await ctx.yizhiModel[type].findAll({
      attributes,
      where,
      offset: size * (page - 1),
      limit: size,
    });
  }

  async create(type, data) {
    const { ctx } = this;
    await ctx.yizhiModel[type].create(data);
  }

  async findOne(type, where, attributes) {
    const { ctx } = this;
    return await ctx.yizhiModel[type].findOne({
      attributes,
      where,
    });
  }

  async count(type, where = {}) {
    const { ctx } = this;
    const ret = await ctx.yizhiModel[type].findOne({
      attributes: [
        [
          ctx.yizhiModel.fn('COUNT', ctx.yizhiModel.col('id')), 'total',
        ],
      ],
      where,
    });
    return ret.get('total');
  }

}

module.exports = UserDetailService;
