/* eslint valid-jsdoc: "off" */

'use strict';

/**
 * @param {Egg.EggAppInfo} appInfo app info
 */
module.exports = appInfo => {
  /**
   * built-in config
   * @type {Egg.EggAppConfig}
   **/
  const config = exports = {};

  config.projectRootPath = '/yizhi_server/api';

  // use for cookie sign key, should change to your own and keep security
  config.keys = appInfo.name + '_1559722467295_3512';

  config.jwtExp = 60 * 60 * 24 * 30;

  // add your middleware config here
  config.middleware = [
    'requestLog',
    'errorHandler',
    'authInit',
    'pagination',
  ];

  config.authInit = {
    ignore: [
      '/yizhi_server/api/price',
      '/yizhi_server/api/account',
      '/yizhi_server/api/user_service',
      '/yizhi_server/api/recharge',
      '/yizhi_server/api/remission',
      '/yizhi_server/api/user/login',
    ],
  }

  config.jwt = {
    secret: 'yizhi_secret',
    exp: Math.floor(Date.now() / 1000) + 60 * 60 * 24 * 30,
    enable: true, // default is false
    ignore: [
      '/yizhi_server/api/price',
      '/yizhi_server/api/account',
      '/yizhi_server/api/user_service',
      '/yizhi_server/api/recharge',
      '/yizhi_server/api/remission',
      '/yizhi_server/api/user/login',
      '/yizhi_server/api/user/logout',
      '/yizhi_server/api/user/password',
    ],
  };

  config.cors = {
    origin: '*',
    allowMethods: 'GET,HEAD,PUT,POST,DELETE,PATCH,OPTIONS',
    credentials: true,
  };

  // 关闭csrf
  config.security = {
    csrf: {
      enable: false,
    },
  };

  return config;
};
