'use strict';
const moment = require('moment');

module.exports = app => {
  const { DataTypes } = app.Sequelize;

  const ddname = app.yizhiModel.define('dd_name', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true,
        autoIncrement: true,
    },
    name: {
      type: DataTypes.STRING(20),
      allowNull: true,
      field: 'name',
    },
    dd_id: {
      type: DataTypes.STRING(20),
      allowNull: true,
      field: 'dd_id',
    },
    status: {
      type: DataTypes.INTEGER(1),
      allowNull: false,
      defaultValue: 1,
      field: 'status',
    },
    created_at: {
      type: DataTypes.DATE,
      get() {
        const date = this.getDataValue('created_at');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
      field: 'created_at',
    },
    updated_at: {
      type: DataTypes.DATE,
      get() {
        const date = this.getDataValue('updated_at');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
      field: 'updated_at',
    },
  }, {
    tableName: 'dd_name',
  });
  return ddname;
};
