'use strict';

/**
 * @param {Egg.Application} app - egg application
 */
module.exports = app => {
  const { controller, middleware } = app;
  const router = app.router.namespace(app.config.projectRootPath + '/account');
  const authInit = middleware.authInit();
  router.get('/home', authInit, controller.account.home); // 合作方首页信息
  router.get('/analyse', authInit, controller.account.analyse); // 调用明细
  router.get('/analyse/download', authInit, controller.account.analyseDownload); // 调用明细下载

};
