'use strict';
const moment = require('moment');

module.exports = app => {
  const { DataTypes } = app.Sequelize;

  const remission = app.yizhiModel.define('remission', {
    id: {
      type: DataTypes.INTEGER(11).UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
      field: 'id',
    },
    appkey: {
      type: DataTypes.STRING(50),
      allowNull: true,
      field: 'appkey',
    },
    count: {
      type: DataTypes.INTEGER(10).UNSIGNED,
      allowNull: false,
      defaultValue: 0,
      field: 'count',
    },
    operator: {
      type: DataTypes.STRING(50),
      allowNull: true,
      field: 'operator',
    },
    created_at: {
      type: DataTypes.DATE,
      get() {
        const date = this.getDataValue('created_at');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'created_at',
    },
    start_time: {
      type: DataTypes.DATE,
      get() {
        const date = this.getDataValue('start_time');
        return date ? moment(date).format('YYYY-MM-DD') : undefined;
      },
      set(val) {
        this.setDataValue('start_time', moment(val, 'YYYY-MM-DD 00:00:00'));
      },
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'start_time',
    },
  }, {
    tableName: 'remission_detail',
    timestamps: false,
  });
  return remission;
};
