'use strict';

const Controller = require('egg').Controller;

class RemissionController extends Controller {

  constructor(ctx) {
    super(ctx);
    this.indexRule = {
      appKey: {
        required: true,
        type: 'string',
      },
    };
    this.createRule = {
      appKey: {
        required: true,
        type: 'string',
      },
      count: {
        required: true,
        type: 'number',
      },
      start_time: {
        required: true,
        type: 'date',
      },
    };
    this.model = 'Remission';
    this.usermodel = 'UserService';
  }
  async index() {
    const { ctx, service } = this;
    ctx.validate(this.indexRule, ctx.query);
    const ret = await service.userDetail.findAll(this.model, { appkey: ctx.query.appKey }, ['appkey', 'start_time', 'count', 'operator'], ctx.pagination);
    const total = await service.userDetail.count(this.model, { appkey: ctx.query.appKey });
    ctx.success({ data: ret, total, ...ctx.pagination });
  }

  async create() {
    const { ctx, service } = this;
    ctx.validate(this.createRule, ctx.request.body);
    const { appKey, count, start_time } = ctx.request.body;
    const user = await service.user.getUserInfo();
    const ret = await service.userDetail.findOne(this.usermodel, { appkey: appKey }, ['user_id', 'service', 'appkey']);
    if (!ret) {
      ctx.throw(400, '无效的appKey');
    }
    await service.userDetail.create(this.model, { appkey: appKey, count, start_time, operator: user.name });
    ctx.success({ appKey });
  }
}

module.exports = RemissionController;
