'use strict';

module.exports = app => {
  const { DataTypes } = app.Sequelize;

  const price = app.yizhiModel.define('price', {
    id: {
      type: DataTypes.INTEGER(8),
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    appkey: {
      type: DataTypes.STRING(50),
      allowNull: false,
    },
    pay_type: {
      type: DataTypes.INTEGER(2),
      allowNull: true,
    },
    price: {
      type: DataTypes.DECIMAL(5, 2),
      allowNull: true,
      defaultValue: 0.00,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'create_time',
    },
    start_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'start_time',
    },
    end_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'end_time',
    },
    operator: {
      type: DataTypes.STRING(50),
      allowNull: false,
    },
  }, {
    tableName: 'price_detail',
    timestamps: false,
  });
  return price;
};
