/* eslint valid-jsdoc: "off" */

'use strict';

/**
 * @param {Egg.EggAppInfo} appInfo app info
 */
module.exports = appInfo => {
  /**
   * built-in config
   * @type {Egg.EggAppConfig}
   **/
  const config = exports = {};

  // use for cookie sign key, should change to your own and keep security
  config.keys = appInfo.name + '_1559722467295_3512';

  config.projectRootPath = '/data_server/yizhi/api';

  // add your middleware config here
  config.middleware = [
    'requestLog',
    'errorHandler',
  ];

  config.cors = {
    origin: '*',
    allowMethods: 'GET,HEAD,PUT,POST,DELETE,PATCH,OPTIONS',
    credentials: true,
  };

  // 关闭csrf
  config.security = {
    csrf: {
      enable: false,
    },
  };

  return config;
};
