'uses strict';

module.exports = () => {
    return async (ctx, next) => {
        const token = ctx.request.get('authorization').replace(/Bearer /, '') || '';

        if (!token) {
            ctx.throw(400, 'jwt failed');
        }
        const token_data = await ctx.service.jwt.decode_token(token);
        const token_black = await ctx.app.memcache.get('yizhi_server_token' + token_data.data.user_id);
        // ctx.logger.info('【token_black：】', token_black, token);
        if (token_black) ctx.app.logger.info('【sso token black：】', token_black, token);
        // if (token_black === token) {
        //     ctx.failed('token 已失效');
        // }
        ctx.token = token || '';
        ctx.userId = token_data.data.user_id || '';
        ctx.logger.info('userId:', ctx.userId);
        next();
    }
}