'use strict';

const Service = require('egg').Service;

class UserService extends Service {

  async getUserInfo() {
    const { ctx, config } = this;
    if (!ctx.header.authorization) {
      ctx.throw(400, 'no Authorization');
    }
    const user = await this.app.cache.get(ctx.header.authorization) || '';
    if (user) {
      return this.app.cache.get(ctx.header.authorization);
    }
    const ret = await ctx.curl(config.userInfoUrl, {
      method: 'GET',
      headers: {
        authorization: ctx.header.authorization,
      },
      dataType: 'json',
      contentType: 'json',
    });
    ctx.logger.info(`【Scripts】fetchParams,${config.userInfoUrl}`, 'result:', JSON.stringify(ret.data));
    if (!(ret.status === 200 && ret.data && ret.data.id)) {
      ctx.failed('no user');
    }
    this.app.cache.set(ctx.header.authorization, ret.data, 300);
    return ret.data;
  }

  async fetchAccount(where = {}, { size, page }) {
    const { ctx } = this;
    return await ctx.yizhiModel.Account.findAll({
      attributes: ['user_id', 'account', 'name', 'company', 'dd_name', 'status'],
      where,
      offset: size * (page - 1),
      limit: size,
    });
  }

  async serviceList(where) {
    const { ctx } = this;
    return await ctx.yizhiModel.UserService.findAll({
      attributes: ['appkey', 'service'],
      where,
    });
  }

  async count(where = {}) {
    const { ctx } = this;
    const ret = await ctx.yizhiModel.Account.findOne({
      attributes: [
        [
          ctx.yizhiModel.fn('COUNT', ctx.yizhiModel.col('user_id')), 'total',
        ],
      ],
      where,
    });
    return ret.get('total');
  }

  async update(where, params) {
    const { ctx } = this;
    const ret = await ctx.yizhiModel.Account.findOne({
      where,
    });
    if (!ret) {
      this.ctx.throw(400, '记录不存在');
    }
    await ret.update(params);
  }

  async findOne(type, where, attributes) {
    const { ctx } = this;
    return await ctx.yizhiModel[type].findOne({
      attributes,
      where,
    });
  }

}
module.exports = UserService;
