'use strict';
const moment = require('moment');

module.exports = app => {
    const { STRING, INTEGER, DATE, DECIMAL } = app.Sequelize;
    const yzbillBalance = app.dataModel.define('yzbillBalance', {
        user_id: { type: INTEGER, primaryKey: true },
        month: INTEGER,
        recharge_hs: STRING,
        cost_hs: STRING,
        balance_bg: STRING,
        recharge_m: STRING,
        cost_m: STRING,
        balance_fn: STRING,
        account: STRING,
        company: STRING,
        name: STRING,
        update_time: {
            type: DATE,
            get() {
                const date = this.getDataValue('update_time');
                return (date && date.toString() !== 'Invalid Date') ? moment(date).format('YYYY-MM-DD HH:mm:ss') : '0000-00-00 00:00:00';
            },
        },
    }, {
        timestamps: false,
        tableName: 'yzbill_balance',
    });
    return yzbillBalance;
};
