'use strict';

/**
 * @param {Egg.Application} app - egg application
 */
module.exports = app => {
  const { controller, middleware } = app;
  const router = app.router.namespace(app.config.projectRootPath + '/user');
  const authInit = middleware.authInit();
  router.post('/login', controller.user.login); // 用户登录
  router.delete('/logout', authInit, controller.user.logout); // 用户登出
  router.put('/password', authInit, controller.user.changePwd); // 修改密码

};
