'use strict';
const moment = require('moment');

module.exports = app => {
  const { DataTypes } = app.Sequelize;

  const userService = app.yizhiModel.define('userService', {
    id: {
      type: DataTypes.INTEGER(11).UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
      field: 'id',
    },
    user_id: {
      type: DataTypes.STRING(50),
      allowNull: false,
      field: 'user_id',
    },
    service: {
      type: DataTypes.STRING(50),
      allowNull: false,
      field: 'service',
    },
    appkey: {
      type: DataTypes.STRING(50),
      allowNull: false,
      field: 'appkey',
    },
    status: {
      type: DataTypes.INTEGER(1),
      allowNull: false,
      defaultValue: 1,
      field: 'status',
    },
    created_at: {
      type: DataTypes.DATE,
      get() {
        const date = this.getDataValue('created_at');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
      field: 'created_at',
    },
    updated_at: {
      type: DataTypes.DATE,
      get() {
        const date = this.getDataValue('updated_at');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
      field: 'updated_at',
    },
  }, {
    tableName: 'yizhi_service',
  });
  userService.associate = function() {
    app.yizhiModel.UserService.belongsTo(app.yizhiModel.Account, { foreignKey: 'user_id', targetKey: 'user_id' });
  };
  return userService;
};
