'use strict';

const Controller = require('egg').Controller;

class PriceController extends Controller {

  constructor(ctx) {
    super(ctx);
    this.indexRule = {
      appKey: {
        required: true,
        type: 'string',
      },
    };
    this.createRule = {
      appKey: {
        required: true,
        type: 'string',
      },
      pay_type: {
        required: true,
        type: 'enum',
        values: [0, 1, 2],
      },
      price: {
        required: true,
        type: 'number',
      },
      start_time: {
        required: true,
        type: 'date',
      },
      end_time: {
        required: true,
        type: 'date',
      },
    };
    this.model = 'Price';
    this.usermodel = 'UserService';
  }
  async index() {
    const { ctx, service } = this;
    ctx.validate(this.indexRule, ctx.query);
    const ret = await service.userDetail.findAll(this.model, { appkey: ctx.query.appKey }, ['pay_type', 'price', 'start_time', 'end_time', 'operator'], ctx.pagination);
    const total = await service.userDetail.count(this.model, { appkey: ctx.query.appKey });
    ctx.success({ data: ret, total, ...ctx.pagination });
  }

  async create() {
    const { ctx, service } = this;
    ctx.validate(this.createRule, ctx.request.body);
    const { appKey, pay_type, price, start_time, end_time } = ctx.request.body;
    const user = await service.user.getUserInfo();
    const ret = await service.userDetail.findOne(this.usermodel, { appkey: appKey }, ['user_id', 'service', 'appkey']);
    if (!ret) {
      ctx.throw(400, '无效的appKey');
    }
    await service.userDetail.create(this.model, { appkey: appKey, pay_type, price, start_time, end_time, operator: user.name });
    ctx.success({ appKey });
  }
}

module.exports = PriceController;
