'use strict';

const Controller = require('egg').Controller;

class UserController extends Controller {

  constructor(ctx) {
    super(ctx);
    this.indexRule = {
      status: {
        required: false,
        type: 'enum',
        values: ['0', '1'],
      },
      account: {
        required: false,
        type: 'string',
      },
      company: {
        required: false,
        type: 'string',
      },
      name: {
        required: false,
        type: 'string',
      },
    };
    this.updateRule = {
      user_id: {
        required: true,
        type: 'string',
      },
      status: {
        required: true,
        type: 'enum',
        values: ['0', '1'],
      },
    };
    this.serviceRule = {
      user_id: {
        required: true,
        type: 'string',
      },
    };
  }
  async index() {
    const { ctx, service } = this;
    const Op = ctx.app.Sequelize.Op;
    ctx.validate(this.indexRule, ctx.query);
    const where = {};
    Object.keys(ctx.query).forEach(key => {
      if (ctx.query[key] && this.indexRule.hasOwnProperty(key)) {
        if (key === 'status') {
          where[key] = ctx.query[key];
        } else {
          where[key] = {
            [Op.like]: `${ctx.query[key]}%`,
          };
        }
      }
    });
    const user = await service.user.getUserInfo();
    const accountData = await service.user.fetchAccount({ dd_id: user.id, dd_name: user.name, ...where }, ctx.pagination);
    const total = await service.user.count({ dd_id: user.id, dd_name: user.name, ...where });
    ctx.success({ data: accountData, total, ...ctx.pagination });
  }


  async update() {
    const { ctx, service } = this;
    ctx.validate(this.updateRule, ctx.request.body);
    const { id } = ctx.params;
    const { status } = ctx.request.body;
    await service.user.update({ user_id: id }, { status });
    ctx.success();
  }

  async serviceList() {
    const { ctx, service } = this;
    ctx.validate(this.serviceRule, ctx.query);
    const { user_id } = ctx.query;
    const ret = await service.user.serviceList({ user_id });
    ctx.success(ret);
  }

}

module.exports = UserController;
