'use strict';

module.exports = () => {
  const config = {};

  /**
   * @member Config#
   * @property {String} KEY - description
   */

  config.logger = {
    dir: '/jianbing/logs/yizhi_server',
  };

  config.sequelize = {
    datasources: [{
      // 东八时区
      timezone: '+08:00',
      delegate: 'yizhiModel',
      baseDir: 'model/yizhi',
      // other sequelize configurations
      dialect: 'mysql',
      host: process.env.MYSQL_PACHONG_HOST || 'rds-jb-08.mysql.rds.aliyuncs.com',
      database: process.env.MYSQL_DATA_SERVER_DB_NAME || 'analysisdata',
      username: process.env.MYSQL_USER || 'hexin',
      password: process.env.MYSQL_PWD || 'gYUHszn9#q',
      port: process.env.MYSQL_PORT || 3306,
    },
    {
      // 东八时区
      timezone: '+08:00',
      delegate: 'dataModel',
      baseDir: 'model/data',
      // other sequelize configurations
      dialect: 'mysql',
      host: process.env.MYSQL_SJZX_HOST || 'rds-jb-17.mysql.rds.aliyuncs.com',
      database: process.env.MYSQL_SJZX_DB_NAME || 'rsync_sjzx',
      username: process.env.MYSQL_SJZX_USER || 'rsync_sjzx',
      password: process.env.MYSQL_SJZX_PWD || 'sNHYdXp2Hd46F5CRvYa63',
      port: 3306,
    }],
  };

  config.userInfoUrl = process.env.USERINFO_URL || 'https://uat-nginx.jianbing.com/cms_api/session';

  return config;
};
