/*
 * @Descripttion:
 * @version:
 * @Author: jd
 * @Date: 2019-06-10 19:49:32
 * @LastEditors: jd
 * @LastEditTime: 2019-12-18 13:56:06
 */
'use strict';

const Controller = require('egg').Controller;

class RechargeController extends Controller {
  constructor(ctx) {
    super(ctx);
    this.indexRule = {
      user_id: {
        required: true,
        type: 'string',
      },
    };
    this.createRule = {
      user_id: {
        required: true,
        type: 'string',
      },
      money: {
        required: true,
        type: 'number',
      },
      receive_time: {
        required: true,
        type: 'date',
      },
      type: {
        required: true,
        type: 'enum',
        value: [ '包年', '预充', '后付', '抵扣', '退款', '其他' ],
      },
      remark: {
        required: false,
        type: 'string',
      },
    };
    this.model = 'Recharge';
    this.usermodel = 'Account';
  }
  async index() {
    const { ctx, service } = this;
    ctx.validate(this.indexRule, ctx.query);
    await service.user.getUserInfo();
    const ret = await service.userDetail.findAll(this.model, { user_id: ctx.query.user_id }, [ 'id', 'user_id', 'money', 'receive_time', 'remark', 'operator' ], ctx.pagination);
    const total = await service.userDetail.count(this.model, { user_id: ctx.query.user_id });
    ctx.success({ data: ret, total, ...ctx.pagination });
  }

  async create() {
    const { ctx, service } = this;
    ctx.validate(this.createRule, ctx.request.body);
    const { user_id, money, receive_time, remark, type } = ctx.request.body;
    const user = await service.user.getUserInfo();
    const ret = await service.userDetail.findOne(this.usermodel, { user_id }, [ 'user_id' ]);
    if (!ret) {
      ctx.throw(400, '无效的user_id');
    }
    await service.userDetail.create(this.model, { user_id, money, receive_time, remark, operator: user.name, type });
    ctx.success({ user_id });
  }
}

module.exports = RechargeController;
