'use strict';

const Controller = require('egg').Controller;

class AccountController extends Controller {

    constructor(ctx) {
        super(ctx);
    }

    async home() {
        const { ctx, service } = this;
        const acount_info = await service.user.accountInfo(ctx.userId);
        ctx.body = acount_info;
    }

    async analyse() {
        const { ctx, service } = this;
        const input_params = ctx.request.query;
        const rule = {
            start_date: {
                required: true,
                type: 'string',
                format: /^[1-9]\d{3}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$|^[1-9]\d{3}-(0[1-9]|1[0-2])$/,
                message: '日期格式错误',
            },
            end_date: {
                required: true,
                type: 'string',
                format: /^[1-9]\d{3}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$|^[1-9]\d{3}-(0[1-9]|1[0-2])$/,
                message: '日期格式错误',
            },
            product: {
                required: false,
                type: 'string'
            },
        }
        ctx.validate(rule, input_params);
        if (start_date > end_date) {
            ctx.throw(400, '起始时间不能大于结束时间');
        }
        const analyse_info = await service.userDetail.analyseInfo(input_params);
        ctx.body = analyse_info;
    }

    async analyseDownload() {

    }
}

module.exports = AccountController;
