'use strict';
const moment = require('moment');

module.exports = app => {
  const { DataTypes } = app.Sequelize;

  const account = app.yizhiModel.define('account', {
    user_id: {
      type: DataTypes.STRING(50),
      allowNull: false,
      primaryKey: true,
      field: 'user_id',
    },
    account: {
      type: DataTypes.STRING(50),
      allowNull: true,
      field: 'account',
    },
    password: {
      type: DataTypes.STRING(50),
      allowNull: true,
      field: 'password',
    },
    name: {
      type: DataTypes.STRING(50),
      allowNull: true,
      field: 'name',
    },
    company: {
      type: DataTypes.STRING(50),
      allowNull: true,
      field: 'company',
    },
    dd_name: {
      type: DataTypes.STRING(20),
      allowNull: true,
      field: 'dd_name',
    },
    dd_id: {
      type: DataTypes.STRING(20),
      allowNull: true,
      field: 'dd_id',
    },
    status: {
      type: DataTypes.INTEGER(1),
      allowNull: false,
      defaultValue: 1,
      field: 'status',
    },
    created_at: {
      type: DataTypes.DATE,
      get() {
        const date = this.getDataValue('created_at');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
      field: 'created_at',
    },
    updated_at: {
      type: DataTypes.DATE,
      get() {
        const date = this.getDataValue('updated_at');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
      field: 'updated_at',
    },
  }, {
    tableName: 'account_list',
  });
  return account;
};
