'use strict';

module.exports = app => {
  const { DataTypes } = app.Sequelize;

  const account = app.yizhiModel.define('account', {
    user_id: {
      type: DataTypes.STRING(50),
      allowNull: false,
      primaryKey: true,
    },
    account: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    name: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    company: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    dd_name: {
      type: DataTypes.STRING(20),
      allowNull: true,
    },
    dd_id: {
      type: DataTypes.STRING(20),
      allowNull: true,
    },
    status: {
      type: DataTypes.INTEGER(2),
      allowNull: false,
      defaultValue: 1,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'create_time',
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'update_time',
    },
  }, {
    tableName: 'account_list',
    timestamps: false,
  });
  return account;
};
