'use strict';

module.exports = app => {
  const { DataTypes } = app.Sequelize;

  const recharge = app.yizhiModel.define('recharge', {
    id: {
      type: DataTypes.INTEGER(8),
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    user_id: {
      type: DataTypes.STRING(50),
      allowNull: false,
    },
    money: {
      type: DataTypes.DECIMAL(10, 2),
      allowNull: true,
    },
    remark: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: 1,
    },
    operator: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'create_time',
    },
    receive_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'receive_time',
    },
  }, {
    tableName: 'recharge_detail',
    timestamps: false,
  });
  recharge.associate = function() {
    app.yizhiModel.Recharge.belongsTo(app.yizhiModel.Account, { foreignKey: 'user_id', targetKey: 'user_id' });
  };
  return recharge;
};
