'use strict';

module.exports = app => {
  const { DataTypes } = app.Sequelize;

  const remission = app.yizhiModel.define('remission', {
    id: {
      type: DataTypes.INTEGER(8),
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    user_id: {
      type: DataTypes.STRING(50),
      allowNull: false,
    },
    service: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    appkey: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    status: {
      type: DataTypes.INTEGER(2),
      allowNull: false,
      defaultValue: 1,
    },
    pay_type: {
      type: DataTypes.STRING(20),
      allowNull: true,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'create_time',
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'update_time',
    },
  }, {
    tableName: 'remission_detail',
    timestamps: false,
  });
  return remission;
};
