'use strict';

module.exports = app => {
  const { DataTypes } = app.Sequelize;

  const userService = app.yizhiModel.define('userService', {
    id: {
      type: DataTypes.INTEGER(8),
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    user_id: {
      type: DataTypes.STRING(50),
      allowNull: false,
    },
    service: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    appkey: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    status: {
      type: DataTypes.INTEGER(2),
      allowNull: false,
      defaultValue: 1,
    },
    pay_type: {
      type: DataTypes.STRING(20),
      allowNull: true,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'create_time',
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'update_time',
    },
  }, {
    tableName: 'account_list',
    timestamps: false,
  });
  userService.associate = function() {
    app.yizhiModel.UserService.belongsTo(app.yizhiModel.Account, { foreignKey: 'user_id', targetKey: 'user_id' });
  };
  return userService;
};
