'use strict';
const moment = require('moment');

module.exports = app => {
    const { STRING, INTEGER, DATE, DECIMAL } = app.Sequelize;
    const billCostMonth = app.dataModel.define('yzbillCostMonth', {
        appKey: { type: INTEGER, primaryKey: true },
        service: STRING,
        day: {
            type: STRING,
            field:'day_month'
        },
        query_volume: INTEGER,
        succ_volume: INTEGER,
        pull_volume: INTEGER,
        pay_type: INTEGER,
        price: DECIMAL,
        pay_volume: INTEGER,
        less_given: INTEGER,
        less_used: INTEGER,
        less_balance: INTEGER,
        cost: STRING,
        user_id: STRING,
        account: STRING,
        company: STRING,
        name: STRING,
        update_time: {
            type: DATE,
            get() {
                const date = this.getDataValue('update_time');
                return (date && date.toString() !== 'Invalid Date') ? moment(date).format('YYYY-MM-DD HH:mm:ss') : '0000-00-00 00:00:00';
            },
        },
    }, {
        timestamps: false,
        tableName: 'yzbill_cost_month',
    });
    return billCostMonth;
};
