'uses strict';

module.exports = () => {
    return async (ctx, next) => {
        const token = ctx.request.get('authorization').replace(/Bearer /, '') || '';

        const token_data = await ctx.service.jwt.decode_token(token);
        if (!token || !token_data) {
            ctx.throw(400, 'jwt failed');
        }
        const token_black = await ctx.app.memcache.get('yizhi_server_token' + token_data.data.user_id);
        // ctx.logger.info('【token_black：】', token_black, token);
        if (token_black !== token) {
            ctx.failed('无效的token');
        }
        ctx.token = token || '';
        ctx.userId = token_data.data.user_id || '';
        ctx.logger.info('userId:', ctx.userId);
        await next();
    }
}