'use strict';
const moment = require('moment');

module.exports = app => {
  const { DataTypes } = app.Sequelize;

  const price = app.yizhiModel.define('price', {
    id: {
      type: DataTypes.INTEGER(11).UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
      field: 'id',
    },
    appkey: {
      type: DataTypes.STRING(50),
      allowNull: false,
      field: 'appkey',
    },
    pay_type: {
      type: DataTypes.INTEGER(2),
      allowNull: true,
      field: 'pay_type',
      defaultValue: 0,
    },
    price: {
      type: DataTypes.DECIMAL(5, 2),
      allowNull: true,
      defaultValue: 0.00,
      field: 'price',
      get() {
        const data = this.getDataValue('price');
        return data ? parseFloat(data).toFixed(2) : '0.00';
      },
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'created_at',
    },
    start_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      get() {
        const date = this.getDataValue('start_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
      set(val) {
        this.setDataValue('start_time', moment(val, 'YYYY-MM-DD 00:00:00'));
      },
      field: 'start_time',
    },
    end_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      get() {
        const date = this.getDataValue('end_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
      set(val) {
        this.setDataValue('end_time', moment(val, 'YYYY-MM-DD 00:00:00'));
      },
      field: 'end_time',
    },
    operator: {
      type: DataTypes.STRING(50),
      allowNull: false,
      field: 'operator',
    },
  }, {
    tableName: 'price_detail',
    timestamps: false,
  });
  return price;
};
