'use strict';

const Service = require('egg').Service;

class JwtService extends Service {

    async apply(data) {
        const { ctx, config, app } = this;
        const exp = Math.round(new Date().getTime() / 1000) + ctx.app.config.jwtExp;
        const secret = ctx.app.config.jwt.secret;
        const auth_token = ctx.app.jwt.sign(
            {
                data,
                exp,
            },
            secret
        );
        await app.memcache.set('yizhi_server_token' + data.user_id, auth_token, config.jwtExp);
        return auth_token;
    }

    async decode_token(token) {
        const { ctx } = this;
        return ctx.app.jwt.decode(token, ctx.app.config.jwt.secret);
    }

    async del_token(token) {
        // 用户登出时将token放到黑名单：置为无效
        const { app, config } = this;
        const token_data = await this.decode_token(token);
        const { user_id } = token_data.data;
        await app.memcache.set('yizhi_server_token' + user_id, '', config.jwtExp);
        return true;
    }
}

module.exports = JwtService;