'use strict';
module.exports = (options, app) => {
  return async function(ctx, next) {
    const { request } = ctx;
    const start = new Date();
    let ms = 0;
    const { header } = request;
    const ipStr = header['x-real-ip'] || header['x-forwarded-for'];
    if (ipStr) {
      request.ip = ipStr;
    }
    await next();
    ms = new Date() - start;
    app.logger.info(
      `[middleware-response-time](${ms}ms) ${request.method} ${request.protocol}://${request.ip}${
        request.originalUrl
      } ${ctx.response.status}`
    );
    // const userId = ctx.user && ctx.user.id ? ctx.user.id : '';
    // const userName = ctx.user && ctx.user.name ? ctx.user.name : '';
    // const ip = ctx.ip && ctx.ip.split(':').pop() || '';
    // const log = {
    //   ip,
    //   method: ctx.method,
    //   request: ctx.url.split('?')[0],
    //   time: ms,
    //   user: userName,
    //   created_by: userId,
    // };
    // ctx.service.system.requestLog.create(log);
    // const changeMethod = [ 'PUT', 'POST', 'DELETE'];
    // if (changeMethod.includes(ctx.method) && userId) {
    //   const changeLog = {
    //     ip,
    //     method: ctx.method,
    //     request: ctx.url.split('?')[0],
    //     time: ms,
    //     user: userName,
    //     params: ctx.request.body || {},
    //     status: ctx.response.status,
    //     respone: ctx.body || {},
    //     created_by: userId,
    //   };
    //   ctx.service.system.requestChangeLog.create(changeLog);
    // }

  };
};
