'use strict';
const moment = require('moment');

module.exports = app => {
  const { DataTypes } = app.Sequelize;

  const recharge = app.yizhiModel.define('recharge', {
    id: {
      type: DataTypes.INTEGER(11).UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
      field: 'id',
    },
    user_id: {
      type: DataTypes.STRING(50),
      allowNull: false,
      field: 'user_id',
    },
    money: {
      type: DataTypes.DECIMAL(10, 2),
      allowNull: true,
      field: 'money',
      get() {
        const data = this.getDataValue('money');
        return data ? parseFloat(data).toFixed(2) : '0.00';
      },
    },
    remark: {
      type: DataTypes.STRING(255),
      allowNull: true,
      field: 'remark',
    },
    operator: {
      type: DataTypes.STRING(50),
      allowNull: true,
      field: 'operator',
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'created_at',
    },
    receive_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      get() {
        const date = this.getDataValue('receive_time');
        return date ? moment(date).format('YYYY-MM-DD') : undefined;
      },
      set(val) {
        this.setDataValue('receive_time', moment(val, 'YYYY-MM-DD 00:00:00'));
      },
      field: 'receive_time',
    },
  }, {
    tableName: 'recharge_detail',
    timestamps: false,
  });
  recharge.associate = function() {
    app.yizhiModel.Recharge.belongsTo(app.yizhiModel.Account, { foreignKey: 'user_id', targetKey: 'user_id' });
  };
  return recharge;
};
