$(function() {

  const C = CanvasKit;
  const searchObject = searchToObject();
  const netMark = searchObject.netMark || 0;
  const userAppKey = searchObject.appkey || '';
  const orderSn = searchObject.orderSn;
  const protocol = searchObject.protocol;
  let step = 0;
  let title = '';
  let agreement_time = '';
  const yysTag = searchObject.yysTag || '';

  $('.checkbox-wrapper input').off('click').on('click', function() {
    if (!agreement_time) {
      agreement_time = new Date();
    }
  });

  $("input[name='args[phoneCode]']").eq(0).attr('disabled', 'disabled');

  const appKeypart = ['61F5B4BDF4FF4C13A8C15FCF877C7EC4',
    '417684C3D8144AD4B3E2BB8E57DCEE20',
    '62CF4C62054447778275C5EC8BC6C1E1',
    '3446C5603585451A9D526622EEF7227F',
    'FFB91058E54C41C58293AC420E7AA59E',
    'BF1166D8FD3748CAAB7F668B582B83DA',
    'A85EACCFADAF4CC5A6DFB87C142F14F1',
    '4B0CDD36D797429DB461BB53C68397D6',
    '4662EDDC0A554C5BAAB06177C830D63B',
    'A754546E72CA426EBBC402524A9C14AF',
    '01A82ADD49884956A34A50F15BBB6916',
    'D99BDCB5F7984494B06765CD63210D75',
    '402C6D7F31E94A76910AE3BC7E35934A',
    'D0DFFCC77DFC4B54B162F3AF644C490E',
    '3F55FF7371A5413B8C323B1D58B99A07',
    'E63B5A52077D48AEB991FFB9E617C680',
    '12C7612FE27F4C779AB37EE52DB107F8',
    'DB3E3A5AB86C40769882D209D4671370',
    '819C519455474A19977F742488F203A8',
    'D5D8CB53EF8849ED83BBE6E2A17406AA',
    '59FE7EF89A154392874145A440F0DD75',
    '25C41ED5D848FDCAB22384AFB7FAEC65',
    '1B5463BB8E84425CA9B0FA3D37524920',
    '8BD467BBFB4446989276AA4DDA57DD57',
    '08216F6A12374BD721B922FC1F357EE2',
    '2941942E89E04378BCA25D57340B5386',
    '339948E78C2F437485C1726DDFE311ED',
    '3B5E00F50C3826439EFA9D71A98F1F29',
    '430FB7B62D9F4960B7CBDFA16432D279',
    '4B92963DEF82C723FF63A692297D2148',
    '57F7ED91A17C4D428A7877F401B367D9',
    '5AF04BCAC0714C3DACE580BE028C8F28',
    '5C94484869DFFF8ECF83FEC6FF04905C',
    '64AC8AF9FC3F4B008A4C56FD418CA36A',
    '65EAE57B7AF747F1885438F9CC4DDCE3',
    '712C3D728D1940F6ACF948B9CD8EC49B',
    '7E6AA154E5444BD6816719D82BC40F00',
    '8C13752159AC317F7A84DCF62DF5C436',
    'A3D62145EBF14E0B9D8A4DCEE43859CC',
    'B4B44488770F4C3686C077EFE2FE3BED',
    'B951C01F74E94A96AA82EA6192958DEC',
    'DD3CA30BCA194697B1927956E243295E',
    'DF33D83AE4564083927CC708A4FB07C1',
    'E6B4EDDFA39849C6A39DDCB3E124BADA',
    'BAAB1BF2E9E8487AA3F2A2238A59558C',
    '06A8C51AB9264375BDBDD54B54DC5B9E',
    'A27E54F49A904F1FA4210FEE8EDAA6BB',
    '46EBBE8468C244E9BB41FE706DB7E7E7',
    '58667FEE58DF4BBC8CBDE6467C407640',
    'B6AD339513824FCE851BF0FED5FD1D37',
    '75581CB02FAA4D66AAFF0816384E5818',
    '49F4339164C14787AE83504CDEDA8846',
    '0B7E2FE88610448E804875DB4C4DF26E',
    'AD62BFD1314941DE8A78C9A840455528',
    '82FFDEC41EBA4C9D81472CA1F59C1B3F',
    'E1422BD4383E463FB5DD502D5AD880DC',
    'EC7DEA631E5F491F9FD4BC23AD5278BE',
  ];

  const appKeypart2 = ['63FF7357DB16733ACD5A026EDFD276FB',
    '897AA35E876E79DEB38AE8ABB4BD3F42',
    '5BD31639D6E5872B98A9E000DE4AD9E1',
    'B68C0F9FD465A5E743D07D32A0FAAC13',
    '3B5E00F50C3826439EFA9D71A98F1F29',
    'E6B4EDDFA39849C6A39DDCB3E124BADA',
    '6FE35C37D51EA5F15D0DC38342F1095D',
    '2BB4A17197997332CB1F5E58ED0F8479',
    '81C441A34D03C6215D6538DAAB0B7E4A',
    'AF661B2B08614497A6FDA311155B56EE',
    '08216F6A12374BD721B922FC1F357EE2',
    '992FEE936B01D09F414165C5AFBC873F',
    '9B6435BC81AC4FD8ED050E250B413328',
    '5C94484869DFFF8ECF83FEC6FF04905C',
    '2033A6F5E06351088DC46B6E46E0728E',
    '7DBDC5F3C0D4AD328FC7CCC679C6A6DB',
    '29DF6E815D51470AB6D6E67FCC577171',
    '635F0982AFCF4E4D932E7DED120AA267',
    '658DB609A2EB48C3880B4E156CD78002',
    '8ABE3AD90E304C9FBEFD763D183F8DA8',
    '1F8ADFDBFADC4B2FB6746FE0EC9D37B6',
    '7AF3C05274FA42CEA073BD8A8BCB48D7',
    '39614E9D0BC54FB8ADE55E95AFBD0CEE',
    'F3DAF191460148AE953AC55BD28E2A79',
    '3993B46AE2CB48EE973029DBB922308A',
    'DE0B276B7C3247D6B2E8CF37E21AE007',
    'C585193F07B74FB3AFC816F0E0280C37',
    'C57B3E06C6984856BAF45E55FF3F6F83',
    '4E1630EE463443E1B64C0ABC694E105E',
    '249DFAFC07A1485D92380BD4BD7B5A80',
    '299F779279FA4777B5F4506F841100C0',
    '09BAB3F1F0004941968465755A955345',
    '5F49A7CAC1AE40F6B747DAC8A38303DD',
    'FBE192E391214203B477E908800200DB',
    '2CB0171848364AA4BE8A6976EB4C0E54',
    '34291266BC4F4758A50916EE875F1B61',
    '8F637A7CD0620B6C2CCDC478A7C4CDC0',
    '310C76C6BBB4404EB19EF6A48F2FC4D5',
    '9BAC6DF923024B0A8F7A9A4260BB790D',
    '526638E07DA2480CB05FD7D481932D48',
    'B212CCCD6F254617982EACAEE49A61BD',
    '9569888626894849BBD08C32402A68C9',
    '8902AC29CBCD45D48F6736BB6E268539',
    'CF952A13C637426687D1BA6D4132B4CD',
    'EC3C2F114CF14701899F71821AEFFC10',
    '80517DC1EB524E0CB32EAADC68FE92EB',
    '3FA8C14350C646E4A39B46D4C7F87579',
    'BF621B76957A4EF09196CCE41EE5085B',
    'B9FE36C3F77F49599B5CFC90320F29CF',
    '34F251656B5E4B0B9DD1D7E252C2436E',
    '8FBAD81E9DE917A5A4371B5C241B2C2E',
    'C6D5C77B20B996819795752415803338',
    '5A96628C6920493C87772C46A9C0812A',
    '8B58D7925FF04FA7A909750963B02FC4',
    'AA6E00B81B00B3EFBCBD8BBD3C6B2BFD',
    '0534D2DB0B464BFABB3F4731A0194E51',
    'F19DFA024E224BCA9261684B3E944184',
    '82273BBBA0964515B6A73D0B0FF6F638',
    'FF9EF6C998004B488CB240DC386AA6C1',
    '2DE70E0C739F470DB455FF34503C1A26',
    '799C4C43EA9E43908B4CDD107F735FEB',
    '737F8B7A649F42B7B90213BD276F05A2',
    '3035C0771960447EA007743BF3C2B22F',
    '5F67C71FB7894BDD864592783E8D1950',
    '1845F4CAED6849DD9D7AF9F074C33CD1',
    'C08F35217A23414484EBA11528C8787C',
    '98D46FB4C4E9463ABEE61A8DA8CFE458',
    'FD999468046C4AC985C8FEAAB0092749',
    'F19DFA024E224BCA9261684B3E944184',
    '7481866537B9452EA582E0C72DA3C4D2',
  ];
  // if(userAppKey=="E6B4EDDFA39849C6A39DDCB3E124BADA"){
  //     $('.kefu').html('400-873-5151').attr('href','tel:4008735151');
  // }
  // if(userAppKey=="08216F6A12374BD721B922FC1F357EE2"){
  //     $('.kefu').html('400-691-5151').attr('href','tel:4006915151');
  // }
  // if(userAppKey=="5C94484869DFFF8ECF83FEC6FF04905C"){
  //     $('.kefu').html('400-860-1515').attr('href','tel:4008601515');
  // }
  console.enabled_server_log = constant.debug;
  function replaceParamVal(paramName, replaceWith) {
    const oUrl = this.location.href.toString();
    const re = eval('/(' + paramName + '=)([^&]*)/gi');
    const nUrl = oUrl.replace(re, paramName + '=' + replaceWith);
    return nUrl;
  }

  function TimingAnimate(opt) {
    C.Animate.call(this, opt);
    this.shifting = 0;
    this.fn = opt.fn;
    this.initial_velocity = +(opt.velocity || opt.v || 0);
    this.max_velocity = +(opt.max_velocity || opt.max_v || 0);
    this.acceleration = +(opt.acceleration || opt.a || 0);
    this.velocity = this.initial_velocity;
  }

  C.extendClass(TimingAnimate, C.Animate, {
    _start() {
      this.shifting = 0;
      this.velocity = this.initial_velocity;
    },
    _update(interval, elapsedTime) {
      let t = elapsedTime / 1000, // 总时间
        a = this.acceleration, // 加速度
        t0 = (this.max_velocity - this.initial_velocity) / a, // 达到最大速度时间点
        t1 = t < t0 ? t : t0, // 匀加速时间
        t2 = t > t0 ? t - t0 : 0, // 匀速时间
        v0 = this.initial_velocity, // 初速度
        mv = this.max_velocity; // 最大速度

      this.shifting = v0 * t1 + 0.5 * a * t1 * t1 + mv * t2;
      this.velocity = v0 + a * t1;
      for (const key in this.fn) {
        if ((key === 'position' || key === 'alpha' || key === 'color') && typeof this.fn[key] === 'function') {
          this.node[key] = this.fn[key].call(this, this.shifting);
        }
      }
    },
  });

  function Ball(radial_radius, radius, position, color) {
    C.Circle.call(this, radius, position, color);
    this.turning_velocity = 4;
    this.shadow.alpha = 1;
    this.status = 'none';
    this.center = this.position;
    this.radial_radius = radial_radius;
    this.tube = radius * 2;
    this.radius = radius * 1.4;

    const scale = 0.85;

    this.points = {
      a: [this.center[0] - this.radial_radius * 0.40 * scale, this.center[1] - this.radial_radius * 0.10 * scale],
      b: [this.center[0] - this.radial_radius * 0.12 * scale, this.center[1] + this.radial_radius * 0.30 * scale],
      c: [this.center[0] + this.radial_radius * 0.57 * scale, this.center[1] - this.radial_radius * 0.31 * scale],
    };

    this.turning_angle = (function(points, o, r) {
      // ax + by + c = 0;
      let a = points.b[1] - points.a[1],
        b = points.a[0] - points.b[0],
        c = points.b[0] * points.a[1] - points.a[0] * points.b[1],
        d = Math.abs((a * o[0] + b * o[1] + c) / Math.sqrt(a * a + b * b));
      return Math.PI * 2 - Math.acos(d / r) - Math.atan(-a / b);
    })(this.points, this.center, this.radial_radius);
  }

  C.extendClass(Ball, C.Circle, {
    _draw(ctx) {
      switch (this.status) {
      case 'none':
        this._draw_none(ctx);
        break;
      case 'timer':
      case 'timer+':
        this._draw_run_timer(ctx);
        break;
      case '-loader':
        this._draw_will_loader(ctx);
        break;
      case 'loader':
        this._draw_run_loader(ctx);
        break;
      case 'loaded':
        this._draw_will_do(ctx);
        break;
      case 'doing':
        this._draw_run_doing(ctx);
        break;
      case 'done':
        this._draw_run_done(ctx);
        break;
      default:

      }
    },
    _get_stretch_rate() {
      return Math.max(0, (this.animate.velocity - this.turning_velocity) / (this.animate.max_velocity - this.turning_velocity));
    },
    _get_I() {
      return Math.max(0, Math.PI * 2 * 0.05 * this._get_stretch_rate());
    },
    _get_point_angle(angle) {
      return this.animate.fn.position.call(this.animate, angle);
    },
    _play() {
      const fn = function(s) {
        return [this.node.center[0] + this.node.radial_radius * Math.sin(s),
          this.node.center[1] + this.node.radial_radius * Math.cos(s)];
      };
      this.animate = new TimingAnimate({
        node: this,
        v: 2,
        max_v: 10,
        a: 0.1,
        fn: {
          position: fn,
        },
      });
      this.position = fn.bind(this.animate)(0);
      this.animate.play();
      this.status = 'loader';
    },
    _draw_none(ctx) {

    },
    _draw_run_timer(ctx) {
      let elapsedTime = this.timer.elapsedTime,
        finishedTime = Math.round(this.time) * 1000,
        startAngle = -Math.PI / 2,
        angle = Math.PI * 2;
      if (finishedTime > elapsedTime) {
        let elapsedSec = Math.floor(elapsedTime / 1000) * 1000,
          elapsedMs = elapsedTime - elapsedSec,
          beatMs = 800;
        angle *= elapsedSec / finishedTime;
        if (elapsedMs > 1000 - beatMs) {
          angle += Math.PI * 2000 * C.Easing.Quadratic.InOut(C.mix(0, 1, (elapsedMs - (1000 - beatMs)) / beatMs)) / finishedTime;
        }
      } else {
        this.timer.stop();
        this.status = 'timer+';
      }

      ctx.save();
      ctx.lineWidth = this.tube;
      ctx.strokeStyle = C.convertColor(this.color, this.alpha);
      ctx.beginPath();
      ctx.arc(this.center[0], this.center[1], this.radial_radius, startAngle, startAngle + angle, false);
      ctx.stroke();
      ctx.restore();
    },
    _draw_will_loader(ctx) {
      let elapsedTime = this.timer.elapsedTime,
        finishedTime = 400,
        startAngle = -Math.PI / 2,
        endAngle = startAngle + Math.PI * 2;
      if (finishedTime > elapsedTime) {
        const a = C.Easing.Quadratic.InOut(finishedTime > elapsedTime ? elapsedTime / finishedTime : 1);
        const b = Math.PI * a;
        startAngle += b;
        endAngle -= b;

        if (endAngle <= startAngle) {
          endAngle = startAngle;
        }

        ctx.save();
        ctx.lineCap = 'round';
        ctx.lineWidth = C.mix(this.tube, this.radius * 2, a);
        ctx.strokeStyle = C.convertColor(this.color, this.alpha);
        ctx.beginPath();
        ctx.arc(this.center[0], this.center[1], this.radial_radius, startAngle, endAngle, false);
        ctx.stroke();
        ctx.restore();
      } else {
        this._play();
      }
    },
    _draw_run_loader(ctx) {
      let v = this.animate.velocity,
        stretch_rate = this._get_stretch_rate(),
        s = this.animate.shifting || 0;
      if (v > this.turning_velocity) {
        this.shadow.enabled = true;
        this.shadow.blur = Math.round(6 * stretch_rate);
        this.alpha = 0.4 + 0.6 * (1 - stretch_rate);
      } else {
        this.shadow.enabled = false;
        this.shadow.blur = 0;
        this.alpha = 1;
      }

      // C.Circle.prototype._draw.call(this,ctx);
      ctx.save();
      if (v <= this.turning_velocity) {
        ctx.fillStyle = C.convertColor(this.color, this.alpha);

        ctx.beginPath();
        ctx.arc(this.position[0], this.position[1], this.radius, 0, Math.PI * 2, true);
        ctx.closePath();
        ctx.fill();
      } else {
        let points = [],
          dI = this.radius / this.radial_radius / 3,
          I = this._get_I();
        this._draw_ring(ctx, s, this._get_I(), 0);

      }
      ctx.restore();
    },
    _draw_ring(ctx, start_angle, I, is_gradient) {
      let points = [],
        dI = this.radius / this.radial_radius / 3;

      for (var i = 0; i * dI <= I; i++) {
        points.push(this._get_point_angle(start_angle - i * dI));
      }
      is_gradient = !!is_gradient;

      let alpha = is_gradient ? 1 : this.alpha;

      ctx.strokeStyle = C.convertColor(this.color, alpha);
      ctx.fillStyle = ctx.strokeStyle;
      ctx.shadowOffsetX = this.shadow.offset.x;
      ctx.shadowOffsetY = this.shadow.offset.y;
      ctx.shadowBlur = this.shadow.blur;
      ctx.shadowColor = C.convertColor(this.color, 1); // 颜色

      let circle_start_angle = -start_angle + Math.PI * 0.5;
      ctx.beginPath();
      ctx.arc(points[0][0], points[0][1], this.radius, circle_start_angle, circle_start_angle + Math.PI, true);
      ctx.closePath();
      ctx.fill();

      var length = points.length,
        point = points.shift(),
        i = 0;

      if (points.length) {
        ctx.beginPath();
        ctx.moveTo(point[0], point[1]);
        while (points.length) {
          if (is_gradient) {
            alpha = C.mix(1, this.alpha, C.Easing.Cubic.Out(i / length));
            ctx.strokeStyle = C.convertColor(this.color, alpha);
            ctx.fillStyle = ctx.strokeStyle;
          }

          ctx.lineWidth = this.radius * 2;
          point = points.shift();
          ctx.lineTo(point[0], point[1]);
          ctx.closePath();
          ctx.stroke();
          ctx.beginPath();
          ctx.moveTo(point[0], point[1]);
          i++;
        }
      }


      ctx.beginPath();
      circle_start_angle = -(start_angle - (length - 1) * dI) - Math.PI * 0.5;
      ctx.arc(point[0], point[1], this.radius, circle_start_angle, circle_start_angle + Math.PI, true);
      ctx.closePath();
      ctx.fill();
    },
    _draw_will_do(ctx) {
      this._draw_run_loader(ctx);
      if ((this.animate.shifting || 0) >= this.turning_angle) {
        this.status = 'doing';
        this.end_timer.start();
      }
    },
    _draw_run_done(ctx) {
      const points = [];
      points.push(this.points.a);
      points.push(this.points.b);
      points.push(this.points.c);
      for (let i = 0; i < points.length - 1; i++) {
        this._draw_lines(ctx, points[i], points[i + 1]);
      }
    },
    _draw_run_doing(ctx) {
      const elapsedTime = this.end_timer.elapsedTime;
      const points = [];
      if (elapsedTime > this.duration) {
        this.status = 'done';
        this._draw_run_done(ctx);
        typeof this._fn === 'function' && this._fn();
        delete this._fn;
        return;
      }
      const f = C.Easing.Back.Out(Math.min(elapsedTime / this.duration, 1));

      if (f < this.a_rate) {
        if (f < this.b_rate) {
          const I = this._get_I() - this.animate.velocity * elapsedTime / 1000;
          if (I > 0) {
            ctx.save();
            this._draw_ring(ctx, this.turning_angle, I, 1);
            ctx.restore();
          }
          points.push(this.turning_point);
        } else {
          points.push(C.mix(this.turning_point, this.points.a, (f - this.b_rate) / (1 - this.b_rate)));
        }
        points.push(C.mix(this.turning_point, this.points.b, f / this.a_rate));
      } else {
        points.push(C.mix(this.turning_point, this.points.a, (f - this.b_rate) / (1 - this.b_rate)));
        points.push(this.points.b);
        points.push(C.mix(this.points.b, this.points.c, (f - this.a_rate) / (1 - this.a_rate)));
      }

      for (let i = 0; i < points.length - 1; i++) {
        this._draw_lines(ctx, points[i], points[i + 1]);
      }
    },
    _draw_lines(ctx, a, b) {
      ctx.save();
      ctx.beginPath();
      ctx.lineWidth = this.radius * 2;
      ctx.lineCap = 'round';
      ctx.strokeStyle = C.convertColor(this.color, 1);
      ctx.moveTo(a[0], a[1]);
      ctx.lineTo(b[0], b[1]);
      ctx.stroke();
      ctx.restore();
    },
    _draw_circle(ctx, point) {
      ctx.save();
      ctx.fillStyle = C.convertColor(this.color, this.alpha);
      ctx.beginPath();
      ctx.arc(point[0], point[1], this.radius, 0, Math.PI * 2, true);
      ctx.closePath();
      ctx.fill();
      ctx.restore();
    },
    play() {
      if (this.timer) {
        this.timer.stop();
      }
      if (this.animate) {
        this.animate.pause();
      }
      if (this.status == 'timer+' || this.status == 'timer') {
        this.status = '-loader';
        this.timer = (new C.Timer()).start();
      } else {
        this._play();
      }
    },
    timing(time, fn) {
      if (this.timer) {
        this.timer.stop();
      }
      if (this.animate) {
        this.animate.pause();
      }
      this.status = 'timer';
      this.alpha = 1;
      this.time = time;
      $('.canvas-dashboard .loader .sec').html(time);
      this.timer = (new C.Timer()).start().repeat(1000, function() {
        const second = time - Math.round(this.elapsedTime / 1000);
        fn(second);
      });

    },
    end(fn) {
      this.status == 'loader' && (this.status = 'loaded') && (function() {
        this.turning_angle = Math.ceil(((this.animate.shifting || 0) - this.turning_angle) / (Math.PI * 2)) * Math.PI * 2 + this.turning_angle;
        this.turning_point = this._get_point_angle(this.turning_angle);
        this.a_rate = 1 / (1 + C.distance(this.points.c, this.points.b) / C.distance(this.turning_point, this.points.b));
        this.b_rate = 1 / (1 + C.distance(this.turning_point, this.points.a) / (this._get_I() * this.radial_radius));
        this.end_timer = new C.Timer();
        this.duration = Math.round((C.distance(this.turning_point, this.points.b) + C.distance(this.points.b, this.points.c)) * (1.70158 + 3) * 1000 / (this.radial_radius * this.animate.velocity));
        this._fn = fn;
      }.bind(this))();
    },
  });


  function CanvasLoader() {
    this.loader = $('.canvas-dashboard');
    this.dashboard = $('.user-fields-dashboard');
    this._init = function() {
      let stage = new C.Stage(),
        width = stage.getWidth(),
        height = stage.getHeight(),
        radius = Math.min(width, height) / 2 * 0.9,
        tube = 3 * radius / 40,
        cirque = new C.Cirque(radius, tube, [width / 2, height / 2], Math.PI * 2);

      this.circle = new Ball(cirque.radius, tube * 0.5, cirque.position),
      this.renderer = new C.Renderer(stage);


      cirque.color = 0xf6f6f6;
      this.circle.shadow.enabled = true;
      this.circle.shadow.blur = 12;
      this.circle.color = 0x439df8;
      stage.add(cirque).add(this.circle);

      this.renderer.on('update', function(event, interval, elapsedTime) {
      });
    };

    this.init = function() {
      if (!this.renderer) {
        if (!$('canvas').is(':visible')) {
          this.dashboard.addClass('loader');
          this._init();
          this.dashboard.removeClass('loader');
        }
      }
    };

    this.play = function() {
      this.init();
      this.dashboard.addClass('loader');
      this.loader.removeClass('pause');
      this.renderer.run();
      if (this.circle.status == 'loader') {
        return;
      }
      this.circle.play();
    };

    this.pause = function() {
      if (this.circle && this.circle.status == 'loader') {
        this.circle.status = 'none';
      }
      this.loader.addClass('pause');
    };

    this.setTag = function(tag) {
      if (this.circle && this.circle.status == 'timer' || this.circle.status == 'timer+') {
        return;
      }
      this.loader.find('.label').html(function() {
        switch (tag) {
        case 'login':
          return '正在登录中...';
        case 'logined':
          return '登录完成，等待授权';
        case 'data':
          return '正在查询中...';
        case 'success':
          return '认证完成';
        case 'query':
          return '任务提交成功';
        }
        return '';
      });
      this.loader.find('.loader>*').not('canvas').detach();
      if (this.text_timeout_timer) {
        clearTimeout(this.text_timeout_timer);
        delete this.text_timeout_timer;
      }
      if (this.text_interval_timer) {
        clearTimeout(this.text_interval_timer);
        delete this.text_interval_timer;
      }
      if (tag == 'query') {
        this.loader.find('.loader').append($('<div>', { class: 'content' })
          .append($('<div>', { class: 'message' }).html('此时退出不影响查询结果')));
        this.text_timeout_timer = setTimeout(function() {
          if (this.circle.status == 'loader') {
            this.loader.find('.loader .message').html('当前查询较慢，可能还需要几秒');
          }
          delete this.text_timeout_timer;
        }.bind(this), 30 * 1000);
      } else if (tag == 'login') {
        this.loader.find('.loader').append($('<div>', { class: 'content' })
          .append($('<div>', { class: 'message' }).html('您可能需要等待十几秒')));
        this.text_timeout_timer = setTimeout(function() {
          if (this.circle.status == 'loader') {
            this.loader.find('.loader .message').html('当前查询较慢，可能还需要几秒');
          }
          delete this.text_timeout_timer;
        }.bind(this), 30 * 1000);
      } else if (tag == 'data') {
        let texts = ['认证时间较长，请耐心等待', '您可能需要等待几分钟'],
          i = 0;
        this.loader.find('.loader').append($('<div>', { class: 'content' })
          .append($('<div>', { class: 'message' }).html(texts[0])));
        this.text_interval_timer = setInterval(function() {
          if (this.circle.status == 'loader') {
            this.loader.find('.loader .message').html(texts[(++i) % texts.length]);
          }
          delete this.text_interval_timer;
        }.bind(this), 10 * 1000);
      }
    };

    this.setText = function(text) {
      this.loader.find('.label').html(text);
    };

    this.timing = function(duration, fn) {
      this.init();
      this.dashboard.addClass('loader');
      this.loader.removeClass('pause');
      const self = this;
      this.renderer.run();
      this.loader.find('.loader >*').not('canvas').detach();
      this.loader.find('.loader').append($('<div>', { class: 'content' })
        .append($('<div>', { class: 'message' }).html('您可能需等待'))
        .append($('<div>', { class: 'sec' })));
      let sign = true;
      this.circle.timing(duration, function(second) {
        if (second <= 0) {
          if (sign) {
            setTimeout(function() {
              self.loader.find('.content').addClass('in');
            }, 800);
          }
          fn && fn.call(self);
        } else {
          if (second == 1) {
            sign = false;
            setTimeout(function() {
              self.loader.find('.content').addClass('in');
            }, 800);
          }
          self.loader.find('.sec').html(second);
        }
      });
    };
    this.end = function(fn) {
      this.circle.end(function() {
        this.renderer.pause();
        fn && fn();
      }.bind(this));
      this.loader.find('.content').addClass('in');
    };
    this.stop = function() {
      this.renderer.pause();
      this.circle.status = 'none';
      this.dashboard.removeClass('loader');
    };
  }

  function CSSLoader() {
    this.dashboard = $('.user-fields-dashboard');
    this.init = function() {
      this.dashboard.addClass('loader');
      $('.canvas-dashboard').hide();
      $('.css-loader-dash').show();
      $('.css-shadow').show();

    };
    this.play = function() {
      this.init();
    };
    this.pause = function() {
      this.dashboard.removeClass('loader');
      $('.css-loader-dash').hide();
      $('.css-shadow').hide();
    };
    this.setTag = function() {
      // this.dashboard.removeClass("loader");
      // $('.css-loader-dash').hide();
      // $('.css-shadow').show()
    };
    this.setText = function() {
      // this.dashboard.removeClass("loader");
      // $('.css-loader-dash').hide();
      // $('.css-shadow').show()
    };
    this.end = function(fn) {
      $('#load').html('认证完成，即将为您跳转');
      fn && fn();
    };
    this.stop = function() {
      this.dashboard.removeClass('loader');
      $('.css-loader-dash').hide();
      $('.css-shadow').hide();
    };
    this.timing = function(duration, fn) {
      const self = this;
      fn && fn.call(self);
    };
  }

  let codeStatus = 1;
  $.fn.bindPhoneActionEvent = $.fn.bindPhoneActionEvent || function() {
    return this.find('.phone-code-action').on('click', function(event) {
      clickStatus = true;
      $("input[name='args[phoneCode]']").eq(0).removeAttr('disabled');
      const self = $(this);
      self.lock(self.data('cd'));

      const params = $('input,select').valMap();
      // console.log('【phone_code】params',JSON.stringify(params))
      self.data('result', 0);
      codeStatus = 0;
      doJsonAjax(
        constant.script_root + 'capture',
        params,
        function(response) {
          codeStatus = 1;
          if (response.code == 106 || response.code == -1) {
            if (response.msg == '') {
              $.prompt('验证码发送失败，请稍后重试');
            } else {
              $.prompt(response.msg);
            }
            self.data('result', -1);
            // console.log('验证码发送失败');
          } else {
            // console.log("success");
            self.data('result', 1);
            $.prompt('验证码发送成功，请注意查收');

          }
        },
        function(code) {
          self.unlock();
          $.prompt('请确认设备已连接到网络');
        }
      );
      constant.hasclick = true;
    }).on('clickready', function() {
      const self = $(this);
      if (!self.is(':visible')) {
        return;
      }
      const result = self.data('result');
      if (result == 1) {
        // $.prompt("验证码正在路上，请再等会");
      } else if (result == -1) {
        $.prompt('没有收到验证码？请再试一次');
      }
    })
      .restoreLock(), this;
  };

  let clickStatus = false;
  function listen_job_v2(params, fn, failed) {
    params.netMark = netMark;
    return (new Scheduler({ timeout: 15 * 60 * 1000, duration: 3000 })).begin(function() {
      const self = this;
      doJsonAjax(
        constant.project_root + 'taskId/get_job',
        params,
        function(result) {
          result = JSON.parse(result);
          // console.log(result)
          switch (+result.data.state) {
          case -1:
            self.end(result.data.state, result.data.result);
            break;
          case -2:
            self.end(result.data.state, result.data.result);
            break;
          case 2:
            self.end(result.data.state);
            break;
          case 1:
            self.end(result.data.state, result.data.html);
            break;
          case 3:
            self.end(result.data.state, result.data.result);
            break;
          default:
            self.update();
            break;
          }
        },
        function(code) {
          self.update();
        }
      );
    }, function(state, result) {
      if (state == -1) {
        failed(result);
      } else {
        fn(state, result);
      }
    }, function(error) {
      failed(error.code == error.TIMEOUT ? '处理超时' : undefined);
    });
  }

  function listen_job_ws_V2(params, success, failed, notify) {
    let url;
    const taskId = params.taskId;
    const orderId = params.orderId;
    let queryString = '?taskId=' + taskId + '&orderId=' + orderId + '&appkey=' + constant.appkey + '&netMark=' + netMark;

    if ('type' in params) {
      queryString += '&type=query';
    }
    if (window.location.protocol == 'http:') {
      url = 'ws://' + window.location.host + '/yysh5/ws/' + queryString;
    } else {
      url = 'wss://' + window.location.host + '/yysh5/ws/' + queryString;
    }
    const ws = require('socket.io-client')(url);
    ws.onclose = function() {
      if (ws.status !== 'close') {
        failed();
        $.prompt('请确认网络连接情况');
      }
    };
    ws.onerror = function() {
      failed();
      console.log('创建webSocket失败');
    };
    ws.onmessage = function(result) {
      if (result.data == 'ok') {
        console.log('ws连接成功');
      } else {
        result = JSON.parse(result.data);
        const state = result.data.state;
        if (state == 2 || state == 3) {
          success();// 任务成功||移动第一步发送验证码任务结束
        } else if (state == -1) {
          failed();// 当前步数失败，重新申请新任务
          $.prompt(result.data.result);
        } else if (state == -2) {
          $.prompt(result.data.result);
          setTimeout(function() {
            if (constant.redirectUrl.length > 0) {
              window.location.href = lastRedirect('failed');
            } else {
              window.location.href = constant.script_root + 'info';
            }

          }, 2000);
        } else if (state == 1) {
          if (constant.hasclick == true) {
            if (/联通/.test($('select[name=cid]').find('option:selected').text())) {
              $('.phone-code-action').unlock();
              showModal(result.data.html);
            } else {
              loader.timing(parseInt($('.phone-code-action').html()) > 0 ? parseInt($('.phone-code-action').html()) : 5, function() {
                showModal(result.data.html);
              });
            }
          } else {
            showModal(result.data.html);
          }
        } else if (state == 5) {
          loader.setTag('query');
        }
        if (state != 5) {
          ws.status = 'close';
          ws.close();
        }

      }
    };
    function showModal(html) {
      constant.hasclick = true;
      if (step == 1) {
        title = '成功登录，请获取二次验证码';
      } else {
        title = '成功登录，请再次获取最新验证码';
      }
      const dialog = $.dialog({
        title,
        html,
        buttons: [

          {
            title: '授权', className: 'confirm', tap() {
              const c = $('input[name]').filter(function() {
                return $(this).attr('name') == 'args[phoneCode]';
              });
              if (c.length == 2 && c.eq(0).val() == c.eq(1).val()) {
                $.prompt('两次验证码是不同的，请获取新的验证码');
                return true;
              }
              if (c.length == 2 && c.eq(1).val().length == 0) {
                $.prompt('短信验证码不能为空');
                return true;
              }
              if (c.length == 1 && c.eq(0).val().length == 0) {
                $.prompt('短信验证码不能为空');
                return true;
              }

              const params = this.$('input[name]').add($('input[name=task_id]')).valMap();
              // notify(new Event("resume"));
              loader.play();
              loader.setTag('data');
              carrier_job_v2(params, success, failed);
            },
          },
        ],
      })
        .on('load', function() {
          // if ($("select[name=cid]").find("option:selected").text() == '吉林电信') {
          //     $("<section>", {'class': 'lamp-wrapper'})
          //         .html('请用本机发送“CXXD”至10001获取验证码')
          //         // .append($(isAppleDevice ? "<a href='sms:10001" + (isAppleDevice ? '&' : '?') + "body=CXXD'>" : "").html("点击发送"))
          //         // .append(isAppleDevice ? '；发送不了，请手动编辑短信' : '')
          //         .prependTo(this.content);
          //     this.$(".action").detach();
          // }
          if ($('select[name=cid]').find('option:selected').text() === '河北电信') {

            $('<section>', { class: 'lamp-wrapper' })
              .html('需要多次验证码，每次都需要重新获取,请耐心等待倒计时结束')
              .prependTo(this.content);
          }
          this.context.find('.dialog-button.confirm').attr('disabled', 'disabled');
          this.context.find('.dialog-button.confirm').submitFields(this.$('input'));
          this.context.bindPhoneActionEvent();
        })
        .on('show', function() {
          // notify(new Event("suspend"));
          $('.dialog-button.confirm').attr('disabled', 'disabled');
          loader.pause();
        });

      dialog.model(true);
      $('.dialog-button.confirm').attr('disabled', 'disabled');
    }


  }


  function searchToObject() {
    let pairs = window.location.search.substring(1).split('&'),
      obj = {},
      pair,
      i;

    for (i in pairs) {
      if (pairs[i] === '') continue;

      pair = pairs[i].split('=');
      obj[decodeURIComponent(pair[0])] = decodeURIComponent(pair[1]);
    }

    return obj;
  }
  function carrier_job_v2(params, fn, failed, notify) {
    if (agreement_time && agreement_time != 1) {
      params.agreement_time = agreement_time;
      agreement_time = 1;
    }
    doJsonAjax(
      constant.script_root + 'submit',
      { ...params, orderId: constant.orderNum },
      function(response) {
        console.log('【submit】', JSON.stringify(response))
        if (response.errcode === 0) {
          const taskId = response.data.task_id;
          if (!!window.WebSocket && window.WebSocket.prototype.send) {
            const wsParams = {
              taskId,
              orderId: constant.orderNum,
              netMark,
            };
            listen_job_ws_V2(wsParams, fn, failed, notify);
          } else {
            const params = { taskId: response.data.task_id, orderId: constant.orderNum, phone: constant.phone, redirectUrl: constant.redirectUrl, appkey: constant.appkey };
            listen_job_v2(params, function(state, result) {
              if (state === 2 || state === 3) {
                fn();
              } else if (state === 1) {
                constant.hasclick = true;
                if (step == 1) {
                  title = '成功登录，请获取二次验证码';
                } else {
                  title = '成功登录，请再次获取最新验证码';
                }
                const dialog = $.dialog({
                  title,
                  html: result,
                  buttons: [

                    {
                      title: '授权', className: 'confirm', tap() {
                        const c = $('input[name]').filter(function() {
                          return $(this).attr('name') == 'args[phoneCode]';
                        });
                        if (c.length == 2 && c.eq(0).val() == c.eq(1).val()) {
                          $.prompt('两次验证码是不同的，请获取新的验证码');
                          return true;
                        }
                        if (c.length == 2 && c.eq(1).val().length == 0) {
                          $.prompt('短信验证码不能为空');
                          return true;
                        }
                        if (c.length == 1 && c.eq(0).val().length == 0) {
                          $.prompt('短信验证码不能为空');
                          return true;
                        }

                        const params = this.$('input[name]').add($('input[name=task_id]')).valMap();
                        // notify(new Event("resume"));
                        loader.play();
                        carrier_job_v2(params, fn, failed);
                      },
                    },
                  ],
                })
                  .on('load', function() {

                    // if ($("select[name=cid]").find("option:selected").text() == '吉林电信') {
                    //     $("<section>", {'class': 'lamp-wrapper'})
                    //         .html('请用本机发送“CXXD”至10001获取验证码')
                    //         // .append($(isAppleDevice ? "<a href='sms:10001" + (isAppleDevice ? '&' : '?') + "body=CXXD'>" : "").html("点击发送"))
                    //         // .append(isAppleDevice ? '；发送不了，请手动编辑短信' : '')
                    //         .prependTo(this.content);
                    //     this.$(".action").detach();
                    // }
                    this.context.find('.dialog-button.confirm').attr('disabled', 'disabled');
                    this.context.find('.dialog-button.confirm').submitFields(this.$('input'));
                    this.context.bindPhoneActionEvent();
                  })
                  .on('show', function() {

                    loader.pause();
                    // notify(new Event("suspend"));
                  });

                dialog.model(true);
                $('.dialog-button.confirm').attr('disabled', 'disabled');
              } else if (state == -1) {
                failed();// 当前步数失败，重新申请新任务
                $.prompt(result);
              } else if (state == -2) {
                $.prompt(result.data.result);
                setTimeout(function() {
                  window.location.href = constant.script_root + 'info';
                }, 2000);
              }
            }
              , function(errmsg) {
              failed();
              if (errmsg) {
                $(document).trigger('receive_error', errmsg);
                $.prompt(errmsg);
              }
            });
          }
        } else {
          setTimeout(function() {
            failed();
            $.prompt(response.data.result);
          }, 250);
        }
      },
      function(code) {
        failed();
        if (code == 500) {
          $.prompt('程序员哥哥写错代码了！');
        } else if (code == 404) {
          $.prompt('接口文件不见了！');
        } else if (code == 0) {
          $.prompt('请确认设备已连接到网络！');
        } else {
          $.prompt('服务器好像挂了！');
        }
      }
    );
  }
  function lastRedirect(status) {
    constant.redirectUrl = decodeURIComponent(constant.redirectUrl);
    let hashStr = '';
    if (constant.redirectUrl.indexOf('#') > -1) {
      hashStr = constant.redirectUrl.split('#')[1];
      constant.redirectUrl = constant.redirectUrl.split('#')[0];
    }
    let lastRedirect = constant.redirectUrl + (constant.redirectUrl.indexOf('?') > -1 ? '&' : '?') + 'orderSn=' + constant.orderNum + '&status=' + status + '&phone=' + $("[name='args[phone]']").val() + '&timestamp=' + (+new Date());
    if (hashStr.length > 0) {
      lastRedirect += '#' + hashStr;
    }
    return lastRedirect;
  }

  function setup_forget_password() {
    let tag = '',
      city = '',
      name = '',
      data = {};
    if (/^(.+)(电信|移动|联通)/.test($('select[name=cid]').find('option:selected').text())) {
      city = RegExp.$1;
      name = RegExp.$2;
    }
    switch (name) {
    case '电信':
      tag = 'ctcc';
      break;
    case '移动':
      tag = 'cmcc';
      break;
    case '联通':
      tag = 'cucc';
      break;
    }
    const cmcc = {
      map: {
        浙江: 0,
        安徽: 0,
        重庆: 1,
        湖北: 0,
        北京: 2,
        广东: 1,
        福建: 0,
        甘肃: 1,
        河北: 1,
        河南: 0,
        海南: 0,
        湖南: 0,
        黑龙江: 0,
        吉林: 1,
        江苏: 0,
        上海: 1,
        四川: 0,
        山东: 0,
        山西: 0,
        陕西: 1,
      },
      data: {
        浙江: {
          body: '2010',
        },
        安徽: {
          body: 'CZMM#身份证号',
          bodyHtml: 'CZMM#<span class="hl">身份证号</span>',
        },
        重庆: {
          body: '702',
        },
        湖北: {
          body: 'CZMM#身份证号',
          bodyHtml: 'CZMM#<span class="hl">身份证号</span>',
        },
        北京: {
          body: 'MMCZ空格身份证号空格新密码空格新密码',
          bodyHtml: 'MMCZ<span class="hl">空格身份证号空格新密码空格新密码</span>',
        },
        广东: {
          body: 'CZMM',
        },
        福建: {
          body: '40*新密码*身份证号#',
          bodyHtml: '40*<span class="hl">新密码</span>*<span class="hl">身份证号</span>#',
        },
        甘肃: {
          body: '602',
        },
        河北: {
          body: 'MMCZ',
        },
        河南: {
          body: '6021空格身份证号',
          bodyHtml: '6021<span class="hl">空格身份证号</span>',
        },
        海南: {
          body: 'CZMM空格身份证号',
          bodyHtml: 'CZMM<span class="hl">空格身份证号</span>',
        },
        湖南: {
          body: 'CZMM#身份证号#新密码#新密码',
          bodyHtml: 'CZMM#<span class="hl">身份证号</span>#<span class="hl">新密码</span>#<span class="hl">新密码</span>',
        },
        黑龙江: {
          body: 'CZMM#身份证号#',
          bodyHtml: 'CZMM#<span class="hl">身份证号</span>#',
        },
        吉林: {
          body: 'CZMM',
        },
        江苏: {
          body: 'CZMM#身份证号',
          bodyHtml: 'CZMM#<span class="hl">身份证号</span>',
        },
        上海: {
          body: 'CZMM',
        },
        四川: {
          body: 'CZMM空格身份证号',
          bodyHtml: 'CZMM<span class="hl">空格身份证号</span>',
        },
        山东: {
          body: '242*身份证号*新密码*新密码',
          bodyHtml: '242*<span class="hl">身份证号</span>*<span class="hl">新密码</span>*<span class="hl">新密码</span>',
        },
        山西: {
          body: 'CZSJMM#身份证号#新密码#新密码',
          bodyHtml: 'CZSJMM#<span class="hl">身份证号</span>#<span class="hl">新密码</span>#<span class="hl">新密码</span>',
        },
        陕西: {
          body: 'CZMM',
        },
      },
    };
    if (tag == 'cmcc' && city in cmcc.map) {
      tag = tag + '_' + cmcc.map[city];
      data = cmcc.data[city];
    }
    if (tag == 'ctcc' && city == '广东') {
      tag = tag + '_0';
    }


    let html = $('#template_' + tag).html();
    if (!html) {
      return;
    }

    'bodyHtml' in data || (data.bodyHtml = data.body);
    /class=\"hl\"/.test(data.bodyHtml) || (data.ps = '<span class="ps">红色部分需手动填写</span>');
    while (/(#{([^}]+)})/.test(html)) {
      let search = RegExp.$1,
        key = RegExp.$2.replace(/^\s*|\s*$/, '');
      html = html.replace(new RegExp('#{\\s*' + key + '\\s*}', 'gi'), key in data ? data[key] : '');
    }

    $('#form [type=password]').closest('.content').after($('<a>').html('忘记密码?').on('click', function() {
      $.dialog({
        title: '忘记服务密码',
        html,
        buttons: [{ title: '我知道了' }],
        style: {
          content: {
            'min-height': 'auto',
            'max-height': 'none',
            padding: '10px 20px',
          },
        },
      }).on('load', function() {
        if (/iP(hone|ad)/.test(navigator.userAgent)) {
          this.$('a[href^=sms]').each(function() {
            const self = $(this);
            self.attr('href', self.attr('href').replace(/\?/gi, '&'));
          });
        }
      }).model();
    }));
  }

  function CarrierQueryV2() {
    const self = this;
    let loader = new CanvasLoader();
    const userAgent = navigator.userAgent;
    const index = userAgent.indexOf('Android');
    if (index >= 0) {
      const androidVersion = parseFloat(userAgent.slice(index + 8));
      if (androidVersion < 4.4) {
        loader = new CSSLoader();
      }
    }

    this.config = $('#carrier-config').data();
    window.loader = loader;
    this.loader = loader;
    this.expiration_time = 0;
  }

  CarrierQueryV2.prototype = {
    start() {
      const self = this;
      // console.log('begin');
      $.dialog.global.clear();
      // console.log('begin1');
      if (self.expiration_time) {
        // console.log('begin2');
        let cd = +new Date() - self.expiration_time;
        cd = Math.round(cd / 1000);
        if (cd >= 5) {
          self.loader.timing(cd, function() {
            if (self.loading) {
              self.loader.play();
            }
          });
          $.dialog.global.blocking = true;
          self.blocking_timer = setTimeout(function() {
            delete self.blocking_timer;
            $.dialog.global.blocking = false;
          }, cd * 1000);
        } else {
          self.loader.play();
        }
      } else {
        // console.log('begin3');
        self.loader.play();
        self.loader.setTag('data');
      }
      this.loading = true;
      // console.log('begin4');
      // var timesRun = 0;
      // var waitCode=setInterval(function () {
      //     console.log(codeStatus)
      //     timesRun += 1;
      //     if(timesRun === 60){
      //         clearInterval(waitCode);
      //         $.prompt('服务器正忙，请稍后重试')
      //         self.loading = false;
      //         self.failed();
      //     }else{
      //         if(codeStatus==1){
      //             clearInterval(waitCode)
      const params = $('input,select').valMap();
      params.remPwd = $('#remPwd').is(':checked') ? 1 : 0;
      params.orderSn = orderSn;
      params.netMark = netMark;
      params.appkey = userAppKey;
      params.city = $('select').val();
      const d = $('input[name]').filter(function() {
        return $(this).attr('name') == 'args[ID]';
      });
      if (d.length == 1 && d.eq(0).val().length != 18) {
        $.prompt('请检查身份证号码是否有效');
        self.loading = false;
        self.failed();
        return;
      }
      params.remPwd = $('#remPwd').is(':checked') ? 1 : 0;
      carrier_job_v2(params, function success() {
        // console.log("success");
        self.loader.end(function() {
          self.success();
        });
      }, function failed() {
        self.loading = false;
        self.failed();
        // console.log('failed');
      }, function notify(event) {
        if (event.type == 'resume') {
          this.loader.play();
          this.loader.setTag('data');
        } else {
          this.loader.pause();
        }
      });
      //     }
      // }

      // },1000)

    },
    success() {
      let second = 3;
      this.timer = setInterval(function() {

        if (second == 0) {
          clearInterval(this.timer);
          delete this.timer;
          this.loader.setText('正在加载最新信息...');
          if (constant.redirectUrl.length > 0) {
            window.location.href = lastRedirect('success');
          }
        } else {
          this.loader.setText('认证完成，' + (second--) + '秒后为您自动跳转');
        }
      }.bind(this), 1000);
    },
    failed() {
      this.loader.stop();
      this.blocking_timer && clearTimeout(this.blocking_timer);
      delete this.blocking_timer;
      $.dialog.global.clear();
      const arsCode = $('input').filter(function() {
        return $(this).attr('name') == 'args[phoneCode]';
      });
      if (arsCode.length == 1) {
        arsCode.val('');
        $('#submit').addClass('disabled').attr('disabled', 'disabled');
      }
      $(document).trigger('setup_task');
    },
    lastFailed() {
      // TODO 最终失败执行的脚本
      this.loader.stop();
      setTimeout(function() {
        window.location.href = lastRedirect('failed');
        // constant.redirectUrl + (constant.redirectUrl.indexOf("?")>-1?"&":"?")+"orderSn="+constant.orderNum+"&status=failed&phone="+$("[name='args[phone]']").val()+"&timestamp="+(+new Date);

      }, 2000);
    },
  };


  $('select[name=cid]').on('input', function(event) {
    const self = $(this);
    self.next().html(self.find('option:selected').text());
    $('#submit').off('click').on('click', function() {
      $.prompt('正在下载' + self.find('option:selected').text() + '配置');
    });
    doJsonAjax(
      constant.script_root + 'fields',
      self.valMap(),
      function(response) {
        if (typeof response === 'string') {
          $('#form').find('>:not(.static-element)').detach();
          $('#form').prepend(response);
          $(document).trigger('mutation');
        } else {
          const errmsg = 'errmsg' in response ? response.errmsg : '未知错误';
          $('#form').html(['<section class="space"></section>',
            '<section class="ico-text-dashboard expr-sad cirque-loader">',
            '<div class="loader"></div>',
            '<div class="ico"></div>',
            '<div class="highlight">' + errmsg + '</div>',
            '<div class="description">点击重新加载</div>',
            '</section>'].join('')).find('.ico-text-dashboard')
            .on('click', function() {
              if ($(this).hasClass('loading')) {
                return;
              }
              $(this).addClass('loading');
              setTimeout(function() {
                self.trigger('input');
              }, 300);
            });
          $('#submit').off('click').addClass('disabled')
            .attr('disabled', 'disabled');
        }
      }, function(code) {
        $('#form').html(['<section class="space"></section>',
          '<section class="ico-text-dashboard network-error cirque-loader">',
          '<div class="loader"></div>',
          '<div class="ico"></div>',
          '</section>'].join('')).find('.ico-text-dashboard')
          .on('click', function() {
            if ($(this).hasClass('loading')) {
              return;
            }
            $(this).addClass('loading');
            setTimeout(function() {
              self.trigger('input');
            }, 300);
          });
        $('#submit').off('click').addClass('disabled')
          .attr('disabled', 'disabled');
      }
    );
  });

  $(document).on('setup_task', function() {
    doJsonAjax(
      constant.script_root + 'tasks',
      {
        scriptId: constant.scriptId,
        orderId: constant.orderNum,
        appkey: constant.appkey,
        phone: constant.phone,
        city: '',
        operator: '',
      },
      function(response) {
        $('[name=task_id]').val(response.task_id);
        step = 0;
      },
      function(code) {
        console.log('【tasks接口code】', code);
        if (code == 500) {
          $.prompt('程序员哥哥写错代码了！');
        } else if (code == 404) {
          $.prompt('接口文件不见了！');
        } else if (code == 0) {
          $.prompt('请确认设备已连接到网络！');
        }
        // else if (code == 201) {
        //   return;
        // } else {
        //   $.prompt('服务器好像挂了！');
        // }
      }
    );
    constant.redirectUrl = constant.redirectUrl.replace('&#x3D;', '=');
    constant.hasclick = false;
    clickStatus = false;
    codeStatus = 1;
  }).on('mutation', function(event) {
    if ($('#form .sys-maintenance').length > 0) {
      $('#submit').off('click').attr('disabled', 'disabled');
    } else {
      const query = new CarrierQueryV2();
      window.query = query;
      $(document).bindPhoneActionEvent();

      switch (constant.orderState) {
      case 'failed':
      case 'login':
        $(document).trigger('setup_task');
        break;
      case 'query':
        loader.play();
        loader.setTag('query');
        if (!!window.WebSocket && window.WebSocket.prototype.send) {
          listen_job_ws_V2({
            taskId: constant.taskId,
            orderId: constant.orderNum,
            type: 'query',
          }, function() {
            loader.end();
            query.success();
          }, function() {
            query.failed();
          });
        } else {
          query.failed();
        }
        break;

      case 'success':
        loader.play();
        loader.setTag('data');
        query.success();
        break;
      default:
        $(document).trigger('setup_task');
        break;
      }


      $('#submit').submitFields($('.input-option')).off('click')
        .on('click', function() {
          if ($('#form').find('.phone-code-action').length > 0) {
            if (clickStatus) {
              query.start();
            } else {
              $.prompt('该地区每次查询都需要重新获取验证码，请先获取验证码');
            }
          } else {
            query.start();
          }


        });
      setup_forget_password();
    }
  })
    .trigger('mutation');


  $(document).on('receive_error', (function() {
    let errcount = 0;
    return function(event, errmsg) {
      if (/密码/gi.test(errmsg)) {
        errcount++;
        if (errcount == 2) {
          $('#form [type=password]').closest('.input-box').find('a')
            .trigger('click');
        }
      }
    };
  })());


  if (yysTag) {
    if (appKeypart2.indexOf(userAppKey) > -1) {
      if (protocol == 1) {
        new $.dialog({
          html: '<iframe frameborder="0" width="100%" height="' + (window.innerHeight * 0.75) + 'px" style="background-color:white;" src="' + constant.script_root + 'protocol#self"></iframe>',
          style: {
            content: {
              padding: 0,
              maxHeight: (window.innerHeight * 0.75) + 'px',

            },
          },
          buttons: [{
            title: '仅浏览', className: 'back', tap() {
              doJsonAjax(
                'https://' + window.location.host + '/bury/bury_point',
                { order_id: orderSn, type: 'yys', button: 'back' },
                function(response) {
                  console.log(response);
                },
                function(code) {
                  console.log(code);
                }
              );
              window.history.go(-1);

              try { window.parent.postMessage({ close: true, type: 'webviewclose' }, '*'); } catch (e) {}
            },
          }, {
            title: '确认并同意', tap() {
              doAjax({
                url: 'https://' + window.location.host + '/bury/bury_point',
                type: 'POST',
                contentType: 'application/json',
                data: {
                  order_id: orderSn,
                  type: 'yys',
                  button: 'agree',
                },
                success(resp) {
                  console.log(resp);
                },
                error(err) {
                  console.error(err);
                },
              });
              const URL = replaceParamVal('protocol', '0');
              history.pushState(null, null, URL);
            },
          }],
        }).model();
      }
    }
  } else {
    if (appKeypart.indexOf(userAppKey) > -1) {
      $('.checkbox-wrapper a').on('click', function() {
        new $.dialog({
          title: '运营商授权协议',
          html: '<iframe frameborder="0" width="100%" height="300px" style="background-color:#f5f5f5;" src= "https://' + window.location.host + '/thxd/protocol"></iframe>',
          style: {
            content: {
              padding: 0,
              maxHeight: '300px',
              backgroundColor: '#f5f5f5',
            },
          },
        }).model();
      });
    } else if (appKeypart2.indexOf(userAppKey) > -1) {
      if (protocol == 1) {
        $('.checkbox-wrapper a').on('click', function() {
          new $.dialog({

            html: '<iframe frameborder="0" width="100%" height="' + (window.innerHeight * 0.75) + 'px" style="background-color:white;" src="' + constant.script_root + 'protocol#self"></iframe>',
            style: {
              content: {
                padding: 0,
                maxHeight: (window.innerHeight * 0.75) + 'px',

              },
            },
            buttons: [{
              title: '仅浏览', className: 'back', tap() {
                doJsonAjax(
                  'https://' + window.location.host + '/bury/bury_point',
                  { order_id: orderSn, type: 'yys', button: 'back' },
                  function(response) {
                    console.log(response);
                  },
                  function(code) {
                    console.log(code);
                  }
                );
                window.history.go(-1);
              },
            }, {
              title: '确认并同意', tap() {
                doAjax({
                  url: 'https://' + window.location.host + '/bury/bury_point',
                  type: 'POST',
                  contentType: 'application/json',
                  data: {
                    order_id: orderSn,
                    type: 'yys',
                    button: 'agree',
                  },
                  success(resp) {
                    console.log(resp);
                  },
                  error(err) {
                    console.error(err);
                  },
                });
                $('.checkbox-wrapper a').off('click').on('click', function() {
                  new $.dialog({
                    title: '信息授权查询委托书',
                    html: '<iframe frameborder="0" width="100%"  height="' + (window.innerHeight * 0.7) + 'px" style="background-color:white;" src= "https://p.jianbing.com/ssr-view/agreement/yys_analysis#self"></iframe>',
                    style: {
                      content: {
                        padding: 0,
                        maxHeight: (window.innerHeight * 0.7) + 'px',

                      },
                    },
                  }).model();
                });
              },
            }],
          }).model();
        });
        $('.checkbox-wrapper a').trigger('click');
      } else {
        $('.checkbox-wrapper a').off('click').on('click', function() {
          new $.dialog({
            title: '信息授权查询委托书',
            html: '<iframe frameborder="0" width="100%"  height="' + (window.innerHeight * 0.7) + 'px" style="background-color:white;" src= "https://p.jianbing.com/ssr-view/agreement/yys_analysis#self"></iframe>',
            style: {
              content: {
                padding: 0,
                maxHeight: (window.innerHeight * 0.7) + 'px',

              },
            },
          }).model();
        });
      }
    } else {
      $('.checkbox-wrapper a').on('click', function() {
        new $.dialog({
          title: '运营商授权协议',
          html: '<iframe frameborder="0" width="100%" height="300px" style="background-color:#f5f5f5;" src= "https://p.jianbing.com/ssr-view/agreement/yys_analysis#self"></iframe>',
          style: {
            content: {
              padding: 0,
              maxHeight: '300px',
              backgroundColor: '#f5f5f5',
            },
          },
        }).model();
      });
    }
  }
});
