'use strict';

module.exports = app => {
  const { DataTypes } = app.Sequelize;

  const taskStatus = app.model.define('taskStatus', {
    id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
      field: 'id',
    },
    orderId: {
      type: DataTypes.STRING(50),
      allowNull: false,
      field: 'orderId',
    },
    taskId: {
      type: DataTypes.STRING(50),
      allowNull: true,
      field: 'taskId',
    },
    userId: {
      type: DataTypes.STRING(500),
      allowNull: true,
      field: 'userId',
    },
    phone: {
      type: DataTypes.STRING(11),
      allowNull: true,
      field: 'phone',
    },
    city: {
      type: DataTypes.STRING(20),
      allowNull: true,
      field: 'city',
    },
    cityId: {
      type: DataTypes.STRING(10),
      allowNull: true,
      field: 'cityId',
    },
    operator: {
      type: DataTypes.STRING(10),
      allowNull: true,
      field: 'operator',
    },
    appKey: {
      type: DataTypes.STRING(50),
      allowNull: false,
      field: 'appKey',
    },
    notifyUrl: {
      type: DataTypes.STRING(500),
      allowNull: true,
      field: 'notifyUrl',
    },
    backUrl: {
      type: DataTypes.STRING(500),
      allowNull: true,
      field: 'backUrl',
    },
    status: {
      type: DataTypes.STRING(20),
      allowNull: true,
      field: 'status',
    },
    note: {
      type: DataTypes.STRING(8000),
      allowNull: true,
      field: 'note',
      get() {
        const note = this.getDataValue('note');
        if (note) {
          try {
            return JSON.parse(note);
          } catch (error) {
            return {};
          }
        }
        return {};
      },
      set(val) {
        this.setDataValue('note', JSON.stringify(val));
      },
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'createDate',
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'updateDate',
    },
    text1: {
      type: DataTypes.STRING(255),
      allowNull: true,
      field: 'text1',
    },
    notice: {
      type: DataTypes.STRING(2),
      allowNull: true,
      field: 'notice',
    },
  },
  {
    tableName: 'yys_status',
  });

  return taskStatus;
};
