'use strict';

/**
 * @param {Egg.Application} app - egg application
 */
module.exports = app => {
  const { router, controller } = app;

  const gjjRouter = router.namespace(app.config.projectRootPath);
  gjjRouter.post('/tasks', controller.task.create); // 创建任务
  gjjRouter.get('/tasks/:taskId', controller.task.show); // 获取任务状态
  gjjRouter.post('/tasks/:taskId/submit', controller.task.submit); // 提交任务参数
  gjjRouter.post('/tasks/:taskId/capture', controller.task.fetchCapture); // 获取验证码

  gjjRouter.post('/callback', controller.task.handleCallback); // 处理回调结果，不对外

  // gjjRouter.get('/scripts', controller.script.fetchScripts); // 获取所有脚本信息

  // gjjRouter.get('/scripts/:phone');// 手机号获取脚本信息
  // gjjRouter.get('/scripts/:scriptId', controller.script.fetchOneScripts); // 获取单一脚本信息

  gjjRouter.get('/help/:scriptId', controller.script.fetchHelpInfo); // 获取帮助信息
  gjjRouter.get('/notice/:scriptId', controller.script.fetchNoticeInfo);// 获取提示信息
  gjjRouter.get('/query_button/:scriptId', controller.script.fetchQueryButtonInfo); // 获取查询按钮信息

  gjjRouter.get('/params', controller.script.fetchParamsInfo); // 获取登录参数字典
  gjjRouter.post('/tokens', controller.token.create); // 创建token
  gjjRouter.post('/orders', controller.order.create); // 创建订单号

  gjjRouter.get('/hubs/:phone/scripts', controller.script.fetchHubSeripts);// 根据phone 获取脚本数据（数组）

  gjjRouter.get('/theme/:appKey', controller.partner.show);// 根据appkey查询合作方主题

  gjjRouter.get('/agreements/:id', controller.partner.fetchAgreements);// 查询协议

  gjjRouter.post('/getToken', controller.token.partnerCreate);// 合作方创建token

  gjjRouter.post('/getOrderSn', controller.order.fetchOrderId);// 合作方获取订单号

  gjjRouter.post('/getThxdData', controller.order.partnerShow);// 合作方获取订单数据

  // gjjRouter.get('/orderData/:appKey/:orderId', controller.order.orderShow);// 获取展示页面数据

};
