'use strict';

module.exports = () => {
  const config = exports = {};
  config.debug = true;

  config.logger = {
    dir: '/jianbing/logs/yysh5',
  };

  config.projectRootPath = '/yysh5';
  config.redis = {
    client: {
      port: 6379,
      host: process.env.REDIS_HOST || '127.0.0.1',
      password: process.env.REDIS_PWD || 'DEV8redis',
      db: 0,
    },
  };

  config.JBnotifyCenter = {
    baseURL: 'https://notifier.getxumi.com/api/notify',
    settingid: process.env.NOTIFY_CENTER || '5cbe89d923775d000163d384',
    appSecret: 'a643bd55222b49c2a2baefa7d98679eb',
  };

  config.taskAPI = {
    host: process.env.TASKAPI_HOST || 'http://tm.51gjj.com:4829',
    createTaskUrl: '/thxdServices/createThxdTask',
    fetchCodeUrl: '/thxdServices/queryThxdCode',
    submitTaskUrl: '/thxdServices/queryThxd',
    fetchTaskUrl: '/thxdServices/getThxdData',
  };

  config.scriptsAPI = {
    host: process.env.SCRIPTSAPI_HOST || 'https://uat-nginx.jianbing.com/zeus-api/v1',
    fetchScriptsUrl: '/chaos/yys/two_dimension_array/queries',
    fetchOneScriptUrl: '/chaos/yys/two_dimension_array/info',
    fetchParamsInfoUrl: '/chaos/yys/login_param_map',
    fetchQueryButtonUrl: '/chaos/yys/query_button',
    fetchHelpUrl: '/chaos/yys/help',
    fetchNoticeUrl: '/chaos/yys/notice',
    fetchHubSeriptsUrl: '/chaos/yys/hubs',
    fetchScriptByCityNameUrl: '/chaos/yys/city_scripts',
    redisScriptsKey: 'URANUS.YYS.SCRIPTS',
    redisParamsKey: 'URANUS.YYS.PARAMS',
    redisScriptListKey: 'URANUS.YYS.SCRIPTLIST',
  };

  config.phoneAreaAPI = {
    bdhost: 'http://mobsec-dianhua.baidu.com/dianhua_api/open/location?tel=',
    alhost: 'https://tcc.taobao.com/cc/json/mobile_tel_segment.htm?tel=',
  };

  config.storageAPI = {
    host: 'https://lan-nginx.jianbing.com/mongo-service',
    writeUrl: '',
    readUrl: '?type=phone&id=',
    writeType: 'phone',
    readDataKey: 'thxdData',
  };

  config.washAPI = {
    host: process.env.WASHAPI_HOST || 'http://t.51gjj.com:3007',
    washUrl: '/dataProcessing',
  };

  config.signatureAPI = {
    host: 'https://lan-nginx.jianbing.com/customer-validation',
    fetchTokenUrl: '/access/gettoken',
    fetchOrderIdUrl: '/order/getordersn',
    signatureUrl: '/access/signvaliditycheck',
    signatureType: 'thxd',
    customerUrl: '/customer/query',
  };

  config.partnerAPI = {
    host: process.env.PARTNERAPI_HOST || 'https://uat-nginx.jianbing.com/zeus-api/v1',
    fetchTheme: '/chaos/theme',
    fetchScripts: '/chaos/partners/scripts',
    fetchAgreements: '/chaos/agreements',
    redisThemePrefix: 'URANUS.YYS.PARNTERS.THEME',
    redisScriptsPrefix: 'URANUS.YYS.PARNTERS.SCRIPTS',
    redisAgreementsPrefix: 'URANUS.YYS.PARNTERS.Agreements',
    fetchInfo: '/chaos/partner',
    redisInfoPrefix: 'URANUS.YYS.PARNTERS.Info',
    redisappKeyLimitPrefix: 'URANUS.YYS.PARNTERS.Limit',
  };

  config.lockKeys = {
    fecthHub: 'URANUS.YYS.HUBS.LOCK',
    fecteToken: 'URANUS.YYS.TOKEN.LOCK',
    token: 'URANUS.YYS.TOKEN',
    fecthParnters: 'URANUS.YYS.PARNTERS.LOCK',
    taskPrefix: 'URANUS.YYS.TASK',
  };

  config.sequelize = {
    datasources: [{
      // 东八时区
      timezone: '+08:00',
      delegate: 'model',
      baseDir: 'model',
      dialect: 'mysql',
      host: process.env.MYSQL_PACHONG_HOST || 'rds-jb-08.mysql.rds.aliyuncs.com',
      database: process.env.MYSQL_DATA_SERVER_DB_NAME || 'data_service_dev',
      username: process.env.MYSQL_USER || 'hexin',
      password: process.env.MYSQL_PWD || 'gYUHszn9#q',
      port: process.env.MYSQL_PORT || 3306,
    }],
  };

  config.callbackUrl = process.env.CALLBACK_URL || 'https://dev-nginx.jianbing.com/yysh5/callback';
  config.dataCallbackUrl = process.env.DATACALLBACK_URL || 'https://dev-nginx.jianbing.com/yysh5/dataCallback';

  return config;
};
