'use strict';

const Controller = require('egg').Controller;

class ScriptController extends Controller {

  constructor(ctx) {
    super(ctx);
    this.hubsRule = {
      phone: {
        type: 'string',
        format: /^(((13[0-9]{1})|(14[0-9]{1})|(15[4-9]{1})|(16[0-9]{1})|(17[0-9]{1})|(18[0-9]{1})|(19[0-9]{1}))+\d{8})$/,
        message: 'phone格式错误',
        required: true,
      },
    };
  }
  async fetchScripts() {
    const { ctx, service } = this;
    const { appKey } = ctx.query;
    let limitScriptsList = false;
    if (appKey) {
      const ret = await service.partner.fetchInfo(appKey);
      if (ret) {
        limitScriptsList = ret.hfExcludeScripts;
      }
    }
    let data = await service.scripts.fetchScripts();
    if (limitScriptsList) {
      data = data.filter(item => {
        return !(limitScriptsList.includes(item.id));
      });
    }
    ctx.success(data);
  }

  async fetchOneScripts() {
    const { ctx, service } = this;
    let { scriptId } = ctx.params;
    if (scriptId === 'auto') {
      const ret = await service.scripts.fetchScriptIdByIp();
      scriptId = ret.scriptId;
    }
    const data = await service.scripts.fetchOneScripts(scriptId);
    ctx.success(data);
  }
  async fetchParamsInfo() {
    const { ctx, service } = this;
    const { refresh = false } = ctx.query;
    const data = await service.scripts.fetchParams(refresh);
    ctx.success(data);
  }

  async fetchHelpInfo() {
    const { ctx, service } = this;
    const { scriptId } = ctx.params;
    const data = await service.scripts.fetchHelp(scriptId);
    ctx.success(data);
  }

  async fetchQueryButtonInfo() {
    const { ctx, service } = this;
    const { scriptId } = ctx.params;
    const data = await service.scripts.fetchQueryButton(scriptId);
    ctx.success(data);
  }

  async fetchNoticeInfo() {
    const { ctx, service } = this;
    const { scriptId } = ctx.params;
    const data = await service.scripts.fetchNotice(scriptId);
    ctx.success(data);
  }

  async fetchHubSeripts() {
    const { ctx, service } = this;
    ctx.validate(this.hubsRule, ctx.params);
    const { phone } = ctx.params;
    const areaInfo = await service.task.phoneArea(phone);
    const cityMap = await service.scripts.fetchScripts();
    let hubId = '';
    cityMap.map(data => {
      if (data.hub_name === areaInfo.province) {
        hubId = data.hub_id;
      }
    });
    let data = await service.scripts.fetchHubSeripts(hubId);
    let result = '';
    data = data.filter(item => {
      if (item.name === (areaInfo.province + areaInfo.operator)) {
        result = item;
        return false;
      }
      return true;
    });
    if (result) {
      data.unshift(result);
    }
    ctx.success(data);
  }
}

module.exports = ScriptController;
