'use strict';

const Service = require('egg').Service;

class IndexService extends Service {
  constructor(ctx) {
    super(ctx);
    const { config } = this;
  }

  _request(url, opts) {
    const { ctx, baseURL } = this;
    url = `${baseURL}${url}`;
    opts = {
      charset: 'utf-8',
      timeout: [30000, 30000],
      dataType: 'json',
      ...opts,
    };
    return ctx.curl(url, opts);
  }

  async getPhoneHtml(cityInfos, operator, phone) {
    let loginHtml = `
<div class="input-box">
            <label>手机号</label>
            <div class="content">
                <div class="input">
                    <input name="args[phone]" type="text" class="input-option required" value="${phone}" disabled/>
                </div>
                <div>
                    <select name="cid">
                
               
`;
    cityInfos.map(item => {
      if (operator.operator.indexOf(item.substr(-2, 2)) > -1) {
        loginHtml += `<option value="${item}" selected="selected" >${item}</option>`;
      } else {
        loginHtml += `<option value="${item}">${item}</option>`;
      }
    });
    loginHtml += `</select>
                <label>${operator.province}${operator.operator}</label>
            </div>
        </div>
    </div>`;
    return loginHtml;
  }

  async getCityHtml(cityInfos, operator, InputVal) {
    const paramMap = {
      name: '姓名',
      ID: '身份证',
      password: '服务密码',
      phoneCode: '验证码',
    };
    let formHtml = `<script type="text/template" id="carrier_dialog_template">
                        <div class="input-box">
                            <label>验证码</label>
                            <div class="content">
                                <div class="input">
                                    <input name="args[code]" type="text" placeholder="请输入短信验证码" class="input-option required" data-label="验证码"/>
                                </div>
                            </div>
                            <button class="action phone-code-action" data-cd="60" data-id="operator-phone-code">免费获取</button>
                        </div>
                    </script>`;
    cityInfos.map(param => {
      if (param.name === 'name' || param.name === 'ID') {
        formHtml += `
                                  <div class="input-box">
                                    <label>${paramMap[param.name]}</label>
                                    <div class="content">
                                        <div class="input">
                                            <input name="args[${param.name}]" type="text" placeholder="请输入${paramMap[param.name]}" class="param input-option required " data-label="${paramMap[param.name]}" value="${InputVal[param.name]}"/>
                                        </div>
                                    </div>
                                </div>`;
      }
      if (param.name === 'phoneCode') {
        formHtml += `
                                  <div class="input-box">
                                    <label>${paramMap[param.name]}</label>
                                    <div class="content">
                                        <div class="input">
                                            <input name="args[${param.name}]"  placeholder="请输入${paramMap[param.name]}" class="param input-option required " data-label="${paramMap[param.name]}"/>
                                        </div>
                                    </div>
                                     <button class="action phone-code-action" data-cd="65" data-id="operator-phone-code">免费获取</button>
                                </div>`;
      }
      if (param.name === 'password') {
        formHtml += `
                                  <div class="input-box">
                                    <label>${paramMap[param.name]}</label>
                                    <div class="content">
                                        <div class="input">
                                            <input name="args[${param.name}]" type="password" placeholder="请输入${paramMap[param.name]}" class=" param  input-option required " data-label="${paramMap[param.name]}" value="${InputVal[param.name]}"/>
                                        </div>
                                    </div>
                                </div>`;
      }
    });
    formHtml += '<i id="carrier-config" data-auth="true" data-code0="true" data-code1="true"></i>';
    return formHtml;
  }

  async getSMSHTML() {
    return `<div class="input-box">
            <label>验证码</label>
            <div class="content">
                <div class="input">
                    <input name="args[phoneCode]" type="text" placeholder="请输入短信验证码" class="input-option required" data-label="验证码"/>
                </div>
            </div>
            <button class="action phone-code-action" data-cd="70" data-id="operator-phone-code">免费获取</button>
        </div>`;
  }
}

module.exports = IndexService;
