'use strict';

const Controller = require('egg').Controller;

// 渲染页面
class IndexController extends Controller {
  constructor(ctx) {
    super(ctx);
    this.paramsRule = {
      phone: {
        type: 'string',
        format: /^1\d{10}$/,
        message: 'phone格式错误',
        required: true,
      },
      orderId: {
        type: 'string',
        format: /^\w{8}(-\w{4}){3}-\w{12}$/,
        message: 'orderId格式错误',
        required: true,
      },
      appkey: {
        type: 'string',
        message: 'appkey格式错误',
        required: true,
      },
    };
  }

  async index() {
    const { ctx, app, service } = this;
    try {
      ctx.validate(this.paramsRule, ctx.query);
    } catch (e) {
      return ctx.render('Err', { message: '参数错误' });
    }
    const { appkey, orderId, phone, redirect } = ctx.query;
    await service.schedules.appKeylist();
    if (!ctx.app.appKeylists.get(appkey)) {
      return ctx.render('Err', { message: '不存在appkey' });
    }

    const phoneInfo = await service.task.phoneArea(phone);
    if (phoneInfo.province === '香港') {
      phoneInfo.province = '广东';
    }

    await service.task.configs();
    const phoneHtml = await service.index.getPhoneHtml(ctx.app.provMap.get(phoneInfo.province.replace(/省/, '')), phoneInfo, phone);
    const data = ctx.app.cityMap.get(phoneInfo.province.replace(/省/, '') + phoneInfo.operator.substr(-2, 2));
    if (data.state === 1) {
      const InputVal = {
        name: '',
        ID: '',
        password: '',
      };

      const formHtml = await service.index.getCityHtml(data.queryStepParam[0].loginParam, phoneInfo.operator, InputVal);
      // ctx.cookie('orderId', orderId);
      // ctx.cookie('appKey', appkey);
      await app.redis.set(phone, JSON.stringify({ city: phoneInfo.province, operator: phoneInfo.operator }), 'EX', '300');
      return ctx.render('mobileV2', {
        title: '运营商认证',
        phoneHtml,
        formHtml,
        phone,
        protocol: '《信息授权查询委托书》',
        State: 'init',
        OrderNum: orderId,
        TaskId: '',
        redirectUrl: redirect,
        appkey,
        scriptId: Number(data.id),
      });
    } else {
      return ctx.render('Err', { message: '暂不支持该运营商' });
    }
  }

  async logs(){
    const { ctx } = this;
    ctx.success('0');
  }
}

module.exports = IndexController;
