window.console = (function() {

  const log = console.log;
  let message_queue = new Array();

  function _() {
    this._init();
  }

  _.prototype = console;

  console._init = function() {
    this.enabled_server_log = false;
    this.enabled_window_log = false;
  };

  console.log = function(msg) {
    log.call(this, msg);
    this._server_log(msg);
    this._window_log(msg);
  };

  console._server_log = function(msg) {
    if (!this.enabled_server_log) {
      return;
    }
    if (msg instanceof Object) {
      msg = JSON.stringify(msg);
    } else {
      msg = '' + msg;
    }
    message_queue.push({ time: +new Date(), message: msg });
    this._check_queue();
  };

  console._window_log = function(msg) {
  };

  console._check_queue = function() {
    if (this._server_flag) {
      return;
    }

    if (message_queue.length > 0) {
      // 消息队列队首元素
      this._server_flag = true;
      setTimeout(function() {
        const data = message_queue;
        message_queue = [];
        doJsonAjax(constant.project_root + 'log', data, function() {
          message_queue.shift();
          this._server_flag = false;
          this._check_queue();
        }.bind(this));
      }.bind(this), 20);

    }
  };
  return new _();
})();
