'use strict';

/**
 * @param {Egg.Application} app - egg application
 */
module.exports = app => {
  const { router, controller, io } = app;

  const yysRouter = router.namespace(app.config.projectRootPath);
  yysRouter.get('/index', controller.index.index);// H5页面

  yysRouter.get('/scripts', controller.task.configs); // 获取所有脚本配置信息
  yysRouter.post('/fields', controller.task.fields);// 更换运营商
  yysRouter.post('/tasks', controller.task.create); // 创建任务
  yysRouter.get('/tasks/:taskId', controller.task.show); // 获取任务状态
  yysRouter.post('/submit', controller.task.submit); // 提交任务参数
  yysRouter.post('/capture', controller.task.fetchCapture); // 获取验证码
  yysRouter.post('/getjob', controller.task.getJob);

  yysRouter.post('/callback', controller.task.handleCallback); // 处理回调结果，不对外
  yysRouter.post('/dataCallback', controller.task.dataCallback);// 数据处理完成结果，不对外
  yysRouter.post('/newdataCallback', controller.task.newdataCallback);// 运营报告处理完成结果，不对外

  // yysRouter.ws('/', controller.task.wslink);
  io.route('/ws', controller.task.wslink);

  // yysRouter.get('/scripts', controller.script.fetchScripts); // 获取所有脚本信息
  // yysRouter.get('/scripts/:phone');// 手机号获取脚本信息
  // yysRouter.get('/scripts/:scriptId', controller.script.fetchOneScripts); // 获取单一脚本信息

  // yysRouter.get('/help/:scriptId', controller.script.fetchHelpInfo); // 获取帮助信息
  // yysRouter.get('/notice/:scriptId', controller.script.fetchNoticeInfo);// 获取提示信息
  // yysRouter.get('/query_button/:scriptId', controller.script.fetchQueryButtonInfo);
}
