'use strict';

module.exports = () => {
  const config = exports = {};
  config.debug = true;

  config.logger = {
    dir: '/jianbing/logs/yysh5',
  };

  config.projectRootPath = '/yysh5';
  config.redis = {
    client: {
      port: 6379,
      host: process.env.REDIS_HOST,
      password: process.env.REDIS_PWD || 'DEV8redis',
      db: 0,
    },
  };
  config.taskAPI = {
    host: process.env.TASKAPI_HOST || 'http://tm.51gjj.com:4821',
    fetchHubsUrl: '',
    createTaskUrl: '/gjjServices/createGjjTask',
    fetchCodeUrl: '/gjjServices/queryGjjCode',
    submitTaskUrl: '/gjjServices/queryGjj',
    fetchTaskUrl: '/gjjServices/getGjjData',
  };

  config.scriptsAPI = {
    host: process.env.SCRIPTSAPI_HOST || 'https://uat-nginx.jianbing.com/zeus-api/v1',
    fetchScriptsUrl: '/chaos/hf/two_dimension_array/queries',
    fetchOneScriptUrl: '/chaos/hf/two_dimension_array/info',
    fetchParamsInfoUrl: '/chaos/hf/login_param_map',
    fetchQueryButtonUrl: '/chaos/hf/query_button',
    fetchHelpUrl: '/chaos/hf/help',
    fetchNoticeUrl: '/chaos/hf/notice',
    fetchHubSeriptsUrl: '/chaos/hf/hubs',
    fetchScriptByCityNameUrl: '/chaos/hf/city_scripts',
    redisScriptsKey: 'URANUS.HF.SCRIPTS',
    redisParamsKey: 'URANUS.HF.PARAMS',
    redisScriptListKey: 'URANUS.HF.SCRIPTLIST',
    cityListUrl: 'https://t.51gjj.com/gjj/getCityConfig',
  };

  config.storageAPI = {
    host: process.env.STORAGEAPI_HOST || 'http://tv.51gjj.com:11252',
    writeUrl: '/data',
    readUrl: '/gjj',
    writeType: 'gjj',
    readDataKey: 'gjjData',
  };

  config.washAPI = {
    host: process.env.WASHAPI_HOST || 'http://tt.51gjj.com:11101',
    washUrl: '/gjj/analyzeGjj',
  };

  config.signatureAPI = {
    host: process.env.SIGNATUREAPI_HOST || 'http://tj3.51gjj.com:5118',
    fetchTokenUrl: '/Access/GetToken',
    fetchOrderIdUrl: '/Order/GetOrderSn',
    signatureUrl: '/Access/SignValidityCheck',
    fetchParnterUrl: '',
    signatureType: 'gjj',
    customerUrl: '/customer/query',
  };

  config.partnerAPI = {
    host: process.env.PARTNERAPI_HOST || 'https://uat-nginx.jianbing.com/zeus-api/v1',
    fetchTheme: '/chaos/theme',
    fetchScripts: '/chaos/partners/scripts',
    fetchAgreements: '/chaos/agreements',
    redisThemePrefix: 'URANUS.HF.PARNTERS.THEME',
    redisScriptsPrefix: 'URANUS.HF.PARNTERS.SCRIPTS',
    redisAgreementsPrefix: 'URANUS.HF.PARNTERS.Agreements',
    fetchInfo: '/chaos/partner',
    redisInfoPrefix: 'URANUS.HF.PARNTERS.Info',
  };

  config.lockKeys = {
    fecthHub: 'URANUS.HF.HUBS.LOCK',
    fecteToken: 'URANUS.HF.TOKEN.LOCK',
    token: 'URANUS.HF.TOKEN',
    fecthParnters: 'URANUS.PARNTERS.LOCK',
    taskPrefix: 'URANUS.HFH5.TASK',
  };

  config.sequelize = {
    datasources: [{
      // 东八时区
      timezone: '+08:00',
      delegate: 'model',
      baseDir: 'model',
      dialect: 'mysql',
      host: process.env.MYSQL_PACHONG_HOST || 'rm-bp1272001633qc0x9o.mysql.rds.aliyuncs.com',
      database: process.env.MYSQL_DATA_SERVER_DB_NAME || 'data_service_dev',
      username: process.env.MYSQL_USER || 'kf_jiandeng',
      password: process.env.MYSQL_PWD || 'Zg23Is9c7d2uKz15abZcV',
      port: process.env.MYSQL_PORT || 3306,
    }],
  };

  config.callbackUrl = process.env.CALLBACK_URL || 'https://dev-nginx.jianbing.com/gjjh5/callback';

  return config;
};
