'use strict';

const Service = require('egg').Service;

class PartnerService extends Service {
  constructor(ctx) {
    super(ctx);
    const { config: { partnerAPI } } = this;
    this.partnerAPI = partnerAPI;
  }

  async notice(order, state, Num = 0) {
    const { ctx, service } = this;
    const { orderId, notifyUrl, userId } = order;
    const dbRes = await service.order.getOneByOrderId({ orderId });
    if (dbRes && notifyUrl && (+dbRes.notice + +dbRes.text1 < 2)) {
      const ret = await ctx.curl(notifyUrl, {
        charset: 'utf-8',
        timeout: [30000, 30000],
        contentType: 'json',
        method: 'POST',
        data: {
          orderId,
          userId,
          status: state,
        },
      }
      );
      ctx.logger.info(`【Partner】 notice ${notifyUrl}`, 'orderId:', orderId, 'result:', ret.status, JSON.stringify(ret.data));
      if (ret.status === 200) {
        if (Num === 0) {
          await order.update({ notice: 1 });
        } else {
          await order.update({ text1: 1 });
        }
      }
    }
    return;
  }

  async appKeyLimit(appKey) {
    const { ctx, partnerAPI: { redisappKeyLimitPrefix } } = this;
    let data = await this.app.redis.get(redisappKeyLimitPrefix);
    if (data) {
      data = JSON.parse(data);
      if (data.includes(appKey)) {
        let limit = await this.app.redis.get(redisappKeyLimitPrefix + appKey);
        if (limit) {
          limit = JSON.parse(limit);
          if (limit.currentCount >= limit.limitCount) {
            ctx.throw(422, { message: 'appKey查询数量超过限制,请联系技术人员' });
          } else {
            // limit.currentCount++;
            // await this.app.redis.set(redisappKeyLimitPrefix + appKey, JSON.stringify({ currentCount: limit.currentCount, limitCount: limit.limitCount }), 'EX', 300);
            await ctx.model.query('UPDATE node_limit set currentCount = currentCount + 1  where appKey = ?', {
              type: 'UPDATE',
              replacements: [appKey],
            });
          }
        }
      }
    } else {
      const dbRes = await ctx.model.NodeLimit.findAll({
        attributes: ['appKey', 'currentCount', 'limitCount'],
        where: { type: 'yys' },
      });
      if (dbRes) {
        const appKeyArray = [];
        for (const item of dbRes) {
          const { appKey, currentCount, limitCount } = item;
          appKeyArray.push(appKey);
          await this.app.redis.set(redisappKeyLimitPrefix + appKey, JSON.stringify({ currentCount, limitCount }), 'EX', 300);
        }
        await this.app.redis.set(redisappKeyLimitPrefix, JSON.stringify(appKeyArray), 'EX', 300);
        if (appKeyArray.includes(appKey)) {
          await ctx.model.query('UPDATE node_limit set currentCount = currentCount + 1  where appKey = ?', {
            type: 'UPDATE',
            replacements: [appKey],
          });
        }
      }
    }
  }
}

module.exports = PartnerService;
