'use strict';
const crypto = require('crypto');
const uuid = require('uuid').v1;
const iconv = require('iconv-lite');

function process(data) {
  const keys = Object.keys(data);
  keys.sort();
  let sign_str = '';
  keys.forEach(key => {
    const v = data[key];
    sign_str += `${key}=${v}&`;
  });
  return sign_str;
}

module.exports.getUuid = function() {
  return uuid();
};

module.exports.decode = function(data) {
  return iconv.decode(data, 'gb2312');
};

/**
 * @desc:通知中心
 * @author: JD
 * @param {Object} content: 需要发送的预警信息模板
 * @return {Boolean} 信息发送状态
 */
module.exports.sendMsg = async function(content) {
  if (!content) return false;
  const { app } = this;
  const { baseURL, settingid, appSecret } = app.config.JBnotifyCenter;
  const t = +new Date();
  let sign_str = process({ timestamp: t, settingid, params: JSON.stringify(content) });
  sign_str += `appsecret=${appSecret}`;
  console.log(sign_str);
  const sign = crypto
    .createHash('md5')
    .update(sign_str)
    .digest('hex')
    .toUpperCase();
  const option = {
    settingid,
    timestamp: t,
    sign,
    params: content,
  };
  const result = await this.app.curl(baseURL, {
    method: 'POST',
    data: option,
    dataType: 'json',
    contentType: 'json',
  });
  return result;
};

