$.extend($.fn, {
  valMap() {
    const data = {};
    for (let i = 0; i < this.length; i++) {
      let ele = $(this[i]),
        name = ele.attr('name'),
        val = ele.val();
      if (ele.is('[type=hidden]') || ele.is('select')) {
        // 自动转换
        if (/^\s*([1-9]\d*|0)\s*$/.test(val)) {
          val = +val;
        } else if (val == 'true') {
          val = true;
        } else if (val == 'false') {
          val = false;
        }
      } else if (ele.is('[type=number]')) {
        val = +val;
      }

      if (name) {
        name = name.replace(/^\s*|\s*$/gi, '');
        if (/^([^\[]+)(?:\s*\[\s*([^\]]+)\s*\])+$/.test(name)) {
          let keys = [name.substr(0, name.indexOf('[')).replace(/^\s*|\s*$/gi, '')];
          keys = keys.concat(name.substr(keys[0].length).replace(/^\s*\[|\]\s*$/gi, '').split(/\]\s*\[/));
          let node = data;
          while (keys.length) {
            const key = keys.shift();
            if (keys.length == 0) {
              node[key] = val;
            } else {
              if (typeof node[key] !== 'object') {
                node = node[key] = {};
              } else {
                node = node[key];
              }
            }
          }
        } else {
          data[name] = val;
        }
      }
    }
    return data;
  },
  inputValidate(config) {
    for (let i = 0; i < this.length; i++) {
      let ele = $(this[i]),
        name = ele.attr('name').replace(/^\s*|\s*$/gi, ''),
        val = ele.val();

      if (!!name && !!config[name]) {
        let rules = config[name];
        if (!rules instanceof Array) {
          rules = [rules];
        }
        for (let j = 0; j < rules.length; j++) {
          const rule = rules[j];
          if (rule.match) {
            if (rule.match == 'phone') {
              if (!/^1\d{10}$/.test(val)) {
                ele.trigger('inputerror', rule.error);
                return true;
              }
            } else if (rule.match == 'IDCard') {
              if (!/^\d{14}(\d{3})?[\dXx]$/.test(val)) {
                ele.trigger('inputerror', rule.error);
                return true;
              }
            }
          } else if (rule.pattern) {
            const regexp = new RegExp(rule.pattern);
            if (!regexp.test(val)) {
              ele.trigger('inputerror', rule.error);
              return true;
            }
          }
        }

      }
    }
    return false;
  },
  submitFields(selector) {
    if (typeof selector === 'string') {
      selector = $(selector);
    } else if (!selector) {
      selector = new $();
    }
    const callback = (function(selector, target) {
      return function() {
        const fields = selector.filter(function() { return $(this).is('.required,[required],[type=checkbox].required-checked'); });
        for (let i = 0; i < fields.length; i++) {
          const r = $(fields[i]);
          if ('|text|password|'.indexOf(('|' + r.attr('type') + '|').toLowerCase()) >= 0 && !r.is(':visible')) {
            continue;
          }
          if (r.hasClass('required') || r.is('[required]')) {
            if (/^\s*$/.test(r.val())) {
              target.attr('disabled', 'disabled');
              return;
            }
          }
          if (r.hasClass('required-checked') && r.is('[type=checkbox]')) {
            if (!r.is(':checked')) {
              target.attr('disabled', 'disabled');
              return;
            }
          }
        }
        target.removeAttr('disabled');
      };
    })(selector, this);

    this.trigger('uninstall').off('uninstall');

    selector.length && this.on('uninstall', function() {
      selector.off('input change', callback);
    }) && selector
      .on('input change', callback)
      .eq(0).trigger('input');
    return this;
  },
  lock(cd) {
    let self = $(this),
      text = self.html(),
      i = cd;
    self.data('origin-text', '免费获取');
    const call = function() {
      if (i > 0) {
        self.html(i + '秒后重试');
        self.attr('disabled', 'disabled');
      } else {
        self.html(self.data('origin-text'));
        self.removeAttr('disabled');
        self.data('timer', 0);
        clearInterval(timer);
        self.trigger('clickready');
      }
      i--;
    };
    var timer = setInterval(call, 1000);
    self.data('timer', timer);
    call();
    const id = self.data('id');
    if (window.localStorage && id) {
      let cache = window.localStorage.lock_cd;
      if (cache) {
        cache = JSON.parse(cache);
      } else {
        cache = {};
      }
      cache[id] = Math.round(new Date().getTime() / 1000) + cd;
      window.localStorage.lock_cd = JSON.stringify(cache);
    }
  },
  unlock() {
    const self = $(this);
    self.html(self.data('origin-text'));
    self.removeAttr('disabled');
    const timer = self.data('timer');
    timer && clearInterval(timer);
    const id = self.data('id');
    if (window.localStorage) {
      let cache = window.localStorage.lock_cd;
      if (cache) {
        cache = JSON.parse(cache);
      } else {
        cache = {};
      }
      delete cache[id];
      window.localStorage.lock_cd = JSON.stringify(cache);
    }
  },
  restoreLock() {
    const self = $(this);
    if (window.localStorage) {
      let cache = window.localStorage.lock_cd;
      if (cache) {
        cache = JSON.parse(cache);
      }
      const now = Math.round(new Date().getTime() / 1000);
      for (const id in cache) {
        const cdt = cache[id];
        if (cdt - now > 0) {
          (self.data('id') == id ? self : self.find('[data-id=' + id + ']')).lock(cdt - now);
        }
      }
    }
  },
  lockCD() {
    const self = $(this);
    const lock_id = self.data('id');
    try {
      if (window.localStorage && lock_id) {
        let cache = window.localStorage.lock_cd;
        if (cache) {
          cache = JSON.parse(cache);
        }
        const now = Math.round(new Date().getTime() / 1000);
        if (lock_id in cache) {
          const cdt = cache[lock_id];
          if (cdt - now > 0) {
            return cdt - now;
          }
        }
      }
    } catch (e) {

    }

    return 0;
  },
});

$(function() {
  $(document).restoreLock();

  $('script[type*=json]').each(function() {
    let self = $(this),
      id = self.attr('id');
    if (id) {
      try {
        window[id] = JSON.parse(self.html());
      } catch (e) {
        window[id] = undefined;
      }
    }
  });
});
