'use strict';
window.onerror = function(errorMessage, scriptURI, lineNumber, columnNumber, errorObj) {
  const enabled_log_back = console.enabled_server_log;
  console.enabled_server_log = true;
  console.log(arguments);
  console.enabled_server_log = enabled_log_back;
};

function getURLParams(url) {
  const urlParts = url.split('?');
  const result = {};
  if (urlParts[1]) {
    const params = urlParts[1].split('&');

    for (let i = 0; i < params.length; ++i) {
      const item = params[i].split('=');
      const key = decodeURIComponent(item[0]);
      const uri_encoded = item[1].replace(/%([^\da-fA-f].)/, '%25$1');
      const val = decodeURIComponent(uri_encoded);
      result[key] = val;
    }
  }
  return result;
}

function serializeParams(data) {
  let serializedParams = '';
  for (const pro in data) {
    serializedParams += (serializedParams.length ? '&' : '') + pro + '=' + encodeURIComponent(data[pro]);
  }
  return serializedParams;
}

function getParams(data, key, default_value) {
  if (data != undefined) {
    return key in data ? data[key] : default_value;
  }
  return default_value;
}

function isFunction(fn) {
  return typeof fn === 'function';
}

function defineReactive(obj, key, val, before_change, after_change, flags) {
  let blocking = false,
    setter,
    getter;
  flags = flags || 0; // 第1位 值一样的情况下是否触发
  if (val instanceof Object && isFunction(val.set) && isFunction(val.get)) {
    setter = val.set;
    getter = val.get;
  } else {
    getter = function() { return val; };
    setter = function(newVal) { val = newVal; };
  }
  Object.defineProperty(obj, key, {
    enumerable: true,
    configurable: true,
    get: function reactiveGetter() {
      return getter.call(obj);
    },
    set: function reactiveSetter(newVal) {
      if (blocking) {
        return;
      }
      blocking = true;
      do {
        if (val === newVal && !(flags & 1)) {
          break;
        }
        if (isFunction(before_change) && before_change.call(obj, val, newVal) === true) {
          break;
        }
        const originVal = val;
        try {
          setter.call(obj, newVal);
          isFunction(after_change) && after_change.call(obj, originVal, val);
        } catch (e) {
          blocking = false;
          throw e;
        }
      } while (false);
      blocking = false;
    },
  });
}

function loadScript(url, fn, error) {
  const script = document.createElement('script');
  script.type = 'text/javascript';
  if (script.readyState) {
    script.onreadystatechange = function() {
      if (script.readyState == 'loaded' || script.readyState == 'complete') {
        script.onreadystatechange = null;
        isFunction(fn) && fn();
      }
    };
  } else {
    script.onload = function() {
      isFunction(fn) && fn();
    };
    script.onerror = function() {
      isFunction(error) && error();
    };
  }
  script.src = url;
  document.body.appendChild(script);
}

function doAjax(args) {
  let request = new XMLHttpRequest(),
    url = getParams(args, 'url', ''),
    data = getParams(args, 'data', {}),
    contentType = getParams(args, 'contentType', 'application/x-www-form-urlencoded'),
    type = getParams(args, 'type', 'get');

  request.onreadystatechange = function() {
    console.log(args, '【doAjax】request=====', JSON.stringify(request))
    if (request.readyState == 4) {
      if (request.status == 200) {
        let dataType = null;
        if ('dataType' in args) {
          dataType = args.dataType;
        } else {
          if (/\bContent\-Type\s*:\s* ([^\n;]+)(?=\n|;)/i.test(request.getAllResponseHeaders())) {
            const contentType = RegExp.$1;
            if (/\bjson\b/i.test(contentType)) {
              dataType = 'json';
            } else {
              dataType = 'text';
            }
          }
        }
        let data = null;
        if (/^json$/i.test(dataType)) {
          data = JSON.parse(request.responseText);
        } else {
          data = request.responseText;
        }
        try {
          if (typeof args.success === 'function') {
            args.success(data);
          }
        } catch (e) {
        }
      } else {
        if (typeof args.error === 'function') {
          args.error(request.status);
        }
      }
    }
  };
  request.onloadstart = function() {
    if (typeof args.loadstart === 'function') {
      args.loadstart();
    }
  };
  request.onprogress = function(event) {
    if (typeof args.progress === 'function') {
      args.progress(event);
    }
  };
  request.timeout = getParams(args, 'timeout', 0);

  if (/^post$/gi.test(type)) {
    request.open('POST', url, true);
    request.setRequestHeader('Content-Type', contentType);
    if (contentType == 'application/x-www-form-urlencoded') {
      var content = typeof data === 'string' ? data : serializeParams(data);
      request.send(content);
    } else if (contentType == 'application/json') {
      var content = typeof data === 'string' ? data : JSON.stringify(data);
      request.send(content);
    }

  } else {
    url += (url.indexOf('?') >= 0 ? '&' : '?') + serializeParams(data);
    request.open('GET', url, true);
    request.send();
  }
}

function doJsonAjax(url, data, success, failed, loadstart, progress) {
  doAjax({
    url,
    type: 'post',
    data,
    contentType: 'application/json',
    success,
    error: failed,
    loadstart,
    progress,
  });
}

function extendMethod(class_name, method_set) {
  for (const method_name in method_set) {
    class_name.prototype[method_name] = method_set[method_name];
  }
}

function EventListener() {
}

extendMethod(EventListener, {
  on(event, func) {
    if (typeof event === 'string' && typeof func === 'function') {
      const list = this['on' + event + 'list'];
      if (list instanceof Array) {
        for (let i = 0; i < list.length; i++) {
          if (list[i] === func) {
            return this;
          }
        }
        list.push(func);
      } else {
        this['on' + event + 'list'] = [func];
      }
    }
    return this;
  },

  off(event, func) {
    const list = this['on' + event + 'list'];
    if (list instanceof Array) {
      if (!func) {
        list.length && list.splice(0, list.length);
      } else {
        for (let i = 0; i < list.length; i++) {
          if (list[i] === func) {
            list.splice(i, 1);
            break;
          }
        }
      }
    }
    return this;
  },

  trigger(event) {
    let result = false,
      list = this['on' + event + 'list'];
    if (list instanceof Array) {
      for (let i = 0; i < list.length; i++) {
        const func = list[i];
        if (typeof func !== 'function') {
          continue;
        }
        const args = Array.prototype.slice.call(arguments, 0);
        args.shift();
        result = result || func.apply(this, args);
      }

    }
    return result;
  },
});

function __() {
  this.timer = 0;
  this.queue = [];
  this.complete = null;
}

__.prototype.then = function(cb, delay) {
  this.queue.push({ callback: cb, delay });
  return this;
};

__.prototype.end = function(cb) {
  this.complete = cb;
  return this;
};

__.prototype.abort = function() {
  if (this.timer) {
    clearTimeout(this.timer);
    this.timer = 0;
  }
  return this;
};

__.prototype.commit = function() {
  const self = this;
  if (this.queue.length && !this.timer) {
    const top = this.queue.shift();
    if (typeof top.callback === 'function') {
      if (typeof top.delay !== 'number' || top.delay <= 0) {
        top.callback.apply(self);
        this.commit();
      } else {
        this.timer = setTimeout(function() {
          top.callback.apply(self);
          self.timer = 0;
          self.commit();
        }, top.delay);
      }
    } else {
      self.commit();
    }
  } else if (!this.queue.length && !this.timer) {
    if (typeof this.complete === 'function') {
      this.complete.apply(this);
      this.complete = null;
    }
  }
  return this;
};

function then(cb, delay) {
  return (new __()).then(cb, delay);
}

$(function() {
  document.body.addEventListener('touchstart', function() {});
});
